/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.jung;

import ch.rakudave.jnetmap.controller.Controller;
import ch.rakudave.jnetmap.controller.Scheduler;
import ch.rakudave.jnetmap.model.Connection;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.plugins.extensions.RightClickAction;
import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.logging.Logger;
import ch.rakudave.jnetmap.view.components.StatusBar;
import ch.rakudave.jnetmap.view.components.TabPanel;
import ch.rakudave.jnetmap.view.preferences.ScriptsPanel;
import ch.rakudave.jnetmap.view.properties.ConnectionProperties;
import ch.rakudave.jnetmap.view.properties.DeviceProperties;
import ch.rakudave.jnetmap.view.properties.InterfaceProperties;
import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AbstractPopupGraphMousePlugin;
import edu.uci.ics.jung.visualization.picking.PickedState;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import org.apache.commons.collections15.Factory;

public class PopupGraphMousePlugin
extends AbstractPopupGraphMousePlugin {
    private Frame owner;
    private Factory<Device> vertexFactory;
    private JMenu plugins;
    private Device vertex;

    public PopupGraphMousePlugin(Frame owner, Factory<Device> vertexFactory) {
        this.owner = owner;
        this.vertexFactory = vertexFactory;
        this.buildPluginsMenu();
    }

    private void buildPluginsMenu() {
        this.plugins = new JMenu(Lang.get("preferences.plugins"));
        this.plugins.setIcon(Icons.get("plugin"));
        List<RightClickAction> rightClickPlugins = Controller.getPluginManager().getExtensions(RightClickAction.class);
        rightClickPlugins.addAll(ScriptsPanel.getScriptPlugins());
        rightClickPlugins.sort(Comparator.comparing(RightClickAction::getName));
        for (final RightClickAction p : rightClickPlugins) {
            this.plugins.add(new AbstractAction(p.getName(), p.getIcon()){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        Scheduler.execute(() -> p.execute(PopupGraphMousePlugin.this.vertex));
                    }
                    catch (Exception ex) {
                        Logger.error("An error occured in plugin '" + p.getName() + "'", ex);
                    }
                }
            });
        }
    }

    @Override
    protected void handlePopup(MouseEvent e) {
        Point p;
        JPopupMenu popup = new JPopupMenu();
        final VisualizationViewer vv = (VisualizationViewer)e.getSource();
        final Layout layout = vv.getGraphLayout();
        final Graph graph = layout.getGraph();
        Point ivp = p = e.getPoint();
        GraphElementAccessor pickSupport = vv.getPickSupport();
        if (pickSupport != null) {
            this.vertex = (Device)pickSupport.getVertex(layout, ((Point2D)ivp).getX(), ((Point2D)ivp).getY());
            final Connection edge = (Connection)pickSupport.getEdge(layout, ((Point2D)ivp).getX(), ((Point2D)ivp).getY());
            PickedState pickedVertexState = vv.getPickedVertexState();
            PickedState pickedEdgeState = vv.getPickedEdgeState();
            if (this.vertex != null) {
                pickedVertexState.pick(this.vertex, false);
                popup.add(new AbstractAction(Lang.get("device.properties"), Icons.get("properties")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        new DeviceProperties(PopupGraphMousePlugin.this.owner, PopupGraphMousePlugin.this.vertex, false);
                    }
                });
                if (ScriptsPanel.isDirty()) {
                    this.buildPluginsMenu();
                }
                if (this.plugins.getMenuComponentCount() > 0) {
                    popup.add(this.plugins);
                }
                popup.add(new AbstractAction(Lang.get("menu.view.refresh"), Icons.get("refresh")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Scheduler.execute(() -> {
                            StatusBar.getInstance().setBusy(true);
                            StatusBar.getInstance().setMessage(Lang.getNoHTML("message.status.update").replaceAll("%name%", PopupGraphMousePlugin.this.vertex.getName()));
                            PopupGraphMousePlugin.this.vertex.updateStatus();
                            try {
                                Collection<Device> neighbors = Controller.getCurrentMap().getNeighbors(PopupGraphMousePlugin.this.vertex);
                                if (!neighbors.isEmpty()) {
                                    for (Device d : neighbors) {
                                        d.updateStatus();
                                    }
                                }
                            }
                            catch (Exception e1) {
                                Logger.error("Failed to update the neighbors of " + PopupGraphMousePlugin.this.vertex, e1);
                            }
                            StatusBar.getInstance().setBusy(false);
                            StatusBar.getInstance().clearMessage();
                            TabPanel.getCurrentTab().repaint();
                        });
                    }
                });
                popup.add(new AbstractAction(Lang.get("action.delete"), Icons.get("remove")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        graph.removeVertex(PopupGraphMousePlugin.this.vertex);
                        vv.repaint();
                    }
                });
            } else if (edge != null) {
                pickedEdgeState.pick(edge, false);
                popup.add(new AbstractAction(Lang.get("connection.properties"), Icons.get("properties")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Pair<Device> p = Controller.getCurrentMap().getEndpoints(edge);
                        if (p.getFirst().equals(p.getSecond())) {
                            new InterfaceProperties(PopupGraphMousePlugin.this.owner, p.getFirst().getInterfaceFor(edge));
                        } else {
                            new ConnectionProperties(PopupGraphMousePlugin.this.owner, edge);
                        }
                    }
                });
                popup.add(new AbstractAction(Lang.get("menu.view.refresh"), Icons.get("refresh")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        edge.updateStatus();
                    }
                });
                popup.add(new AbstractAction(Lang.get("action.delete"), Icons.get("remove")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        graph.removeEdge(edge);
                        vv.repaint();
                    }
                });
            } else {
                popup.add(new AbstractAction(Lang.get("action.add"), Icons.get("add")){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        Device newVertex = (Device)PopupGraphMousePlugin.this.vertexFactory.create();
                        new DeviceProperties(PopupGraphMousePlugin.this.owner, newVertex, true);
                        graph.addVertex(newVertex);
                        layout.setLocation(newVertex, vv.getRenderContext().getMultiLayerTransformer().inverseTransform(p));
                        vv.repaint();
                    }
                });
            }
            if (popup.getComponentCount() > 0) {
                popup.show(vv, e.getX(), e.getY());
            }
        }
    }
}

