/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.view.components;

import ch.rakudave.jnetmap.controller.Actions;
import ch.rakudave.jnetmap.controller.Controller;
import ch.rakudave.jnetmap.controller.RecentlyOpened;
import ch.rakudave.jnetmap.controller.command.Command;
import ch.rakudave.jnetmap.controller.command.CommandHistory;
import ch.rakudave.jnetmap.controller.command.CommandListener;
import ch.rakudave.jnetmap.model.CurrentMapListener;
import ch.rakudave.jnetmap.model.Map;
import ch.rakudave.jnetmap.util.IO;
import ch.rakudave.jnetmap.util.Icons;
import ch.rakudave.jnetmap.util.Lang;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.SwingHelper;
import ch.rakudave.jnetmap.view.ISidebar;
import ch.rakudave.jnetmap.view.IView;
import ch.rakudave.jnetmap.view.components.AboutDialog;
import ch.rakudave.jnetmap.view.components.NetworkScanner;
import ch.rakudave.jnetmap.view.components.OUILookup;
import ch.rakudave.jnetmap.view.components.PortScanner;
import ch.rakudave.jnetmap.view.components.StatusBar;
import ch.rakudave.jnetmap.view.components.TabPanel;
import ch.rakudave.jnetmap.view.components.ToolBar;
import ch.rakudave.jnetmap.view.jung.EditModeListener;
import ch.rakudave.jnetmap.view.properties.MapProperties;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileNameExtensionFilter;

public class MenuBar
extends JMenuBar
implements CurrentMapListener,
CommandListener,
EditModeListener {
    private static final long serialVersionUID = -1861842226695622060L;
    private IView parent;
    private JMenuItem undo;
    private JMenuItem redo;
    private JMenuItem mode_pick;
    private JMenuItem mode_edit;
    private JMenuItem mode_transform;
    private JPopupMenu popupMenu;
    private Action popupAction;
    private boolean hidden;
    private CommandHistory commandHistory;

    public MenuBar(IView parent) {
        this.parent = parent;
        this.add(this.createFileMenu());
        this.add(this.createEditMenu());
        this.add(this.createViewMenu());
        this.add(this.createToolMenu());
        this.add(this.createHelpMenu());
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.createFileMenu());
        this.popupMenu.add(this.createEditMenu());
        this.popupMenu.add(this.createViewMenu());
        this.popupMenu.add(this.createToolMenu());
        this.popupMenu.add(this.createHelpMenu());
        this.popupAction = new AbstractAction(Lang.getNoHTML("menu"), Icons.get("hamburger")){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton b = (JButton)e.getSource();
                MenuBar.this.popupMenu.show(b, (int)b.getAlignmentX(), (int)b.getAlignmentY() + b.getHeight());
            }
        };
        this.setVisible(Settings.getBoolean("menu.visible", true));
        Controller.addCurrentMapListener(this);
        TabPanel.addEditModeListener(this);
    }

    private JMenu createFileMenu() {
        JMenu menu = new JMenu(Lang.getNoHTML("menu.file"));
        JMenuItem i = new JMenuItem(Actions.newMap(Lang.getNoHTML("menu.file.new")));
        menu.add(i);
        i.setAccelerator(KeyStroke.getKeyStroke(78, 128));
        i = new JMenuItem(Actions.open(Lang.getNoHTML("menu.file.open")));
        menu.add(i);
        i.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        JMenu recent = new JMenu(Lang.getNoHTML("menu.file.recent"));
        recent.setIcon(Icons.get("recent"));
        recent.addMenuListener(new RecentlyOpened(recent));
        menu.add(recent);
        menu.add(new JSeparator());
        i = new JMenuItem(Actions.save());
        menu.add(i);
        i.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        i = new JMenuItem(Actions.saveAs());
        menu.add(i);
        i.setAccelerator(KeyStroke.getKeyStroke(83, 192));
        i = new JMenuItem(new AbstractAction(Lang.getNoHTML("menu.file.exportimg"), Icons.get("export-img")){

            @Override
            public void actionPerformed(ActionEvent e) {
                File f = SwingHelper.saveDialog(null, new FileNameExtensionFilter("Portable Network Graphics", "png"));
                if (f == null || TabPanel.getCurrentTab() == null) {
                    return;
                }
                IO.exportImage(TabPanel.getCurrentTab().vv, f);
            }
        });
        menu.add(i);
        i.setAccelerator(KeyStroke.getKeyStroke(69, 192));
        menu.add(new JSeparator());
        i = new JMenuItem(new AbstractAction(Lang.getNoHTML("menu.file.properties"), Icons.get("properties")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Controller.getCurrentMap() == null) {
                    return;
                }
                new MapProperties((Frame)((Object)Controller.getView()), Controller.getCurrentMap());
            }
        });
        menu.add(i);
        i.setAccelerator(KeyStroke.getKeyStroke(80, 192));
        menu.add(new JSeparator());
        i = new JMenuItem(Actions.restart(Lang.getNoHTML("menu.file.restart")));
        menu.add(i);
        i = new JMenuItem(Actions.quit(Lang.getNoHTML("menu.file.quit")));
        menu.add(i);
        i.setAccelerator(KeyStroke.getKeyStroke(81, 128));
        return menu;
    }

    private JMenu createEditMenu() {
        JMenu menu = new JMenu(Lang.getNoHTML("menu.edit"));
        this.undo = new JMenuItem(Actions.undo());
        menu.add(this.undo);
        this.undo.setAccelerator(KeyStroke.getKeyStroke(90, 128));
        this.redo = new JMenuItem(Actions.redo());
        menu.add(this.redo);
        this.redo.setAccelerator(KeyStroke.getKeyStroke(89, 128));
        menu.add(new JSeparator());
        this.mode_pick = new JMenuItem(TabPanel.getPickingModeSetter());
        menu.add(this.mode_pick);
        this.mode_pick.setAccelerator(KeyStroke.getKeyStroke(82, 128));
        this.mode_edit = new JMenuItem(TabPanel.getEditingModeSetter());
        menu.add(this.mode_edit);
        this.mode_edit.setAccelerator(KeyStroke.getKeyStroke(69, 128));
        this.mode_transform = new JMenuItem(TabPanel.getTransformingModeSetter());
        menu.add(this.mode_transform);
        this.mode_transform.setAccelerator(KeyStroke.getKeyStroke(84, 128));
        menu.add(new JSeparator());
        JMenuItem i = new JMenuItem(Actions.preferences(Lang.getNoHTML("menu.edit.preferences")));
        menu.add(i);
        i.setAccelerator(KeyStroke.getKeyStroke(80, 128));
        return menu;
    }

    private JMenu createViewMenu() {
        JMenu menu = new JMenu(Lang.getNoHTML("menu.view"));
        JMenuItem i = new JMenuItem(Actions.refresh());
        menu.add(i);
        i.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        JMenu sub = new JMenu(Lang.getNoHTML("menu.view.layout"));
        for (Action a : TabPanel.getLayoutTransformerActions()) {
            sub.add(a);
        }
        menu.add(sub);
        menu.add(new JSeparator());
        i = new JMenuItem(TabPanel.getZoomPlus());
        menu.add(i);
        i.setAccelerator(KeyStroke.getKeyStroke(521, 128));
        i = new JMenuItem(TabPanel.getZoomMinus());
        menu.add(i);
        i.setAccelerator(KeyStroke.getKeyStroke(45, 128));
        i = new JMenuItem(TabPanel.getZoomReset());
        menu.add(i);
        i.setAccelerator(KeyStroke.getKeyStroke(48, 128));
        menu.add(new JSeparator());
        JCheckBoxMenuItem toggleToolbar = new JCheckBoxMenuItem(Lang.getNoHTML("menu.view.toolbar"), ToolBar.getInstance().isVisible());
        toggleToolbar.addActionListener(e -> ToolBar.getInstance().setVisible(toggleToolbar.isSelected()));
        toggleToolbar.setAccelerator(KeyStroke.getKeyStroke(84, 192));
        menu.add(toggleToolbar);
        if (this.parent instanceof ISidebar) {
            JCheckBoxMenuItem toggleSidebar = new JCheckBoxMenuItem(Lang.getNoHTML("menu.view.sidebar"), ((ISidebar)((Object)this.parent)).isSidebarVisible());
            toggleSidebar.addActionListener(e -> ((ISidebar)((Object)this.parent)).setSidebarVisible(toggleSidebar.isSelected()));
            toggleSidebar.setAccelerator(KeyStroke.getKeyStroke(82, 192));
            menu.add(toggleSidebar);
        }
        JCheckBoxMenuItem toggleStatusbar = new JCheckBoxMenuItem(Lang.getNoHTML("menu.view.statusbar"), StatusBar.getInstance().isVisible());
        toggleStatusbar.addActionListener(e -> StatusBar.getInstance().setVisible(toggleStatusbar.isSelected()));
        toggleStatusbar.setAccelerator(KeyStroke.getKeyStroke(66, 192));
        menu.add(toggleStatusbar);
        MenuBar _this = this;
        JCheckBoxMenuItem toggleMenubar = new JCheckBoxMenuItem(Lang.getNoHTML("menu.view.menubar"), this.isVisible());
        toggleMenubar.addActionListener(e -> _this.setVisible(toggleMenubar.isSelected()));
        toggleMenubar.setAccelerator(KeyStroke.getKeyStroke(77, 192));
        menu.add(toggleMenubar);
        return menu;
    }

    private JMenu createToolMenu() {
        JMenu menu = new JMenu(Lang.getNoHTML("menu.tools"));
        menu.add(new JMenuItem(new AbstractAction(Lang.getNoHTML("port.scanner"), Icons.get("find")){

            @Override
            public void actionPerformed(ActionEvent e) {
                new PortScanner((Frame)((Object)MenuBar.this.parent), "127.0.0.1");
            }
        }));
        menu.add(new JMenuItem(new AbstractAction(Lang.getNoHTML("oui.lookup")){

            @Override
            public void actionPerformed(ActionEvent e) {
                new OUILookup((Frame)((Object)MenuBar.this.parent));
            }
        }));
        menu.add(new JMenuItem(new AbstractAction(Lang.getNoHTML("network.scanner"), Icons.get("net")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (Controller.getCurrentMap() == null) {
                    Actions.newMap("").actionPerformed(null);
                }
                new NetworkScanner((Frame)((Object)MenuBar.this.parent), Controller.getCurrentMap());
            }
        }));
        return menu;
    }

    private JMenu createHelpMenu() {
        JMenu menu = new JMenu(Lang.getNoHTML("menu.help"));
        menu.add(new JMenuItem(Actions.viewDoc(Lang.getNoHTML("menu.help.doc"))));
        menu.add(new JSeparator());
        menu.add(new JMenuItem(Actions.viewWebsite()));
        menu.add(new JMenuItem(Actions.reportBug()));
        menu.add(new JMenuItem(Actions.requestFeature()));
        menu.add(new JMenuItem(Actions.contactDeveloper()));
        menu.add(new JSeparator());
        menu.add(new JMenuItem(new AbstractAction(Lang.getNoHTML("about"), Icons.get("info")){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AboutDialog((Frame)((Object)Controller.getView()));
            }
        }));
        return menu;
    }

    @Override
    public void setVisible(boolean aFlag) {
        ToolBar toolbar = ToolBar.getInstance();
        Settings.put("menu.visible", aFlag);
        boolean bl = this.hidden = !aFlag;
        if (aFlag) {
            toolbar.remove("hamburger");
        } else {
            String layout;
            toolbar.add("hamburger", this.popupAction);
            if (!toolbar.isVisible()) {
                toolbar.setVisible(true);
            }
            if (!(layout = Settings.get("toolbar.layout", "new,open,save,|,undo,redo,|,map.pick,map.edit,map.transform,|,refresh,map.zoomin,map.zoomout,-,hamburger")).contains("hamburger")) {
                Settings.put("toolbar.layout", layout + ",-,hamburger");
            }
        }
        this.revalidate();
        toolbar.rebuildToolbarLayout();
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension pref = super.getPreferredSize();
        if (this.hidden) {
            pref.height = 0;
        }
        return pref;
    }

    @Override
    public void executed(Command c) {
        this.redo.setEnabled(false);
        this.undo.setEnabled(true);
    }

    @Override
    public void undone(Command command) {
        this.redo.setEnabled(true);
        this.undo.setEnabled(this.commandHistory.canUndo());
    }

    @Override
    public void redone(Command command) {
        this.redo.setEnabled(this.commandHistory.canRedo());
        this.undo.setEnabled(true);
    }

    @Override
    public void mapChanged(Map map) {
        if (this.commandHistory != null) {
            this.commandHistory.removeCommandListener(this);
        }
        this.commandHistory = map.getHistory();
        this.commandHistory.addCommandListener(this);
        this.redo.setEnabled(this.commandHistory.canRedo());
        this.undo.setEnabled(this.commandHistory.canUndo());
    }

    @Override
    public void editModeChanged(ModalGraphMouse.Mode mode) {
        this.mode_pick.setEnabled(!ModalGraphMouse.Mode.PICKING.equals((Object)mode));
        this.mode_edit.setEnabled(!ModalGraphMouse.Mode.EDITING.equals((Object)mode));
        this.mode_transform.setEnabled(!ModalGraphMouse.Mode.TRANSFORMING.equals((Object)mode));
    }
}

