/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.util.logging;

import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.logging.Appender;
import ch.rakudave.jnetmap.util.logging.ConsoleAppender;
import java.util.ArrayList;
import java.util.List;

public class Logger {
    private static List<Appender> appenders = Logger.init();

    public static void addAppender(Appender a) {
        if (a != null) {
            appenders.add(a);
        }
    }

    public static void debug(String message) {
        Logger.log(Level.DEBUG, message, null);
    }

    public static void debug(String message, Throwable t) {
        Logger.log(Level.DEBUG, message, t);
    }

    public static void error(String message) {
        Logger.log(Level.ERROR, message, null);
    }

    public static void error(String message, Throwable t) {
        Logger.log(Level.ERROR, message, t);
    }

    public static void fatal(String message) {
        Logger.log(Level.FATAL, message, null);
    }

    public static void fatal(String message, Throwable t) {
        Logger.log(Level.FATAL, message, t);
    }

    public static List<Appender> getAppenders() {
        return new ArrayList<Appender>(appenders);
    }

    public static void info(String message) {
        Logger.log(Level.INFO, message, null);
    }

    public static void info(String message, Throwable t) {
        Logger.log(Level.INFO, message, t);
    }

    private static List<Appender> init() {
        appenders = new ArrayList<Appender>();
        appenders.add(new ConsoleAppender(Level.valueOf(Settings.get("logger.ConsoleAppender", "WARN"))));
        return appenders;
    }

    public static void log(Level level, String message, Throwable t) {
        for (Appender a : appenders) {
            a.append(level, message, t);
        }
    }

    public static void trace(String message) {
        Logger.log(Level.TRACE, message, null);
    }

    public static void trace(String message, Throwable t) {
        Logger.log(Level.TRACE, message, t);
    }

    public static void warn(String message) {
        Logger.log(Level.WARN, message, null);
    }

    public static void warn(String message, Throwable t) {
        Logger.log(Level.WARN, message, t);
    }

    public static enum Level {
        OFF,
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

