/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.net;

import ch.rakudave.jnetmap.controller.Scheduler;
import ch.rakudave.jnetmap.model.IF.NetworkIF;
import ch.rakudave.jnetmap.model.IF.PhysicalIF;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.util.IO;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.logging.Logger;
import java.io.IOException;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Properties;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SNMP {
    private static Properties mibs;

    public static HashMap<String, String> getValues(InetAddress address) {
        DefaultUdpTransportMapping transport;
        HashMap<String, String> oid = new HashMap<String, String>();
        if (address == null) {
            return oid;
        }
        CommunityTarget comtarget = new CommunityTarget();
        comtarget.setCommunity(new OctetString(Settings.get("snmp.community", "public")));
        comtarget.setVersion(Settings.getInt("snmp.version", 1));
        comtarget.setAddress(new UdpAddress(address.getHostAddress() + "/" + Settings.getInt("snmp.port", 161)));
        comtarget.setRetries(2);
        comtarget.setTimeout(Settings.getInt("snmp.timeout", 3000));
        try {
            transport = new DefaultUdpTransportMapping();
            transport.listen();
        }
        catch (IOException e) {
            Logger.error("Failed to open UDP transport", e);
            return oid;
        }
        Snmp snmp = new Snmp(transport);
        PDU pdu = new PDU();
        pdu.setType(-96);
        if (mibs == null) {
            mibs = SNMP.loadMIB();
        }
        HashMap<String, String> names = new HashMap<String, String>();
        for (Object key : mibs.keySet()) {
            String name = key.toString();
            pdu.add(new VariableBinding(new OID(mibs.getProperty(name))));
            names.put(mibs.getProperty(name), name);
        }
        Logger.debug("SNMP " + comtarget.toString());
        try {
            ResponseEvent response = snmp.get(pdu, comtarget);
            if (response != null) {
                PDU responsePDU = response.getResponse();
                if (responsePDU != null) {
                    int errorStatus = responsePDU.getErrorStatus();
                    if (errorStatus == 0) {
                        for (VariableBinding variableBinding : responsePDU.getVariableBindings()) {
                            String value = variableBinding.getVariable().toString();
                            if (value == null || "".equals(value)) continue;
                            oid.put((String)names.get(variableBinding.getOid().toString()), value);
                        }
                        Logger.debug(oid.toString());
                    } else {
                        int errorIndex = responsePDU.getErrorIndex();
                        String string = responsePDU.getErrorStatusText();
                        Logger.error("SNMP error: status " + errorStatus + ", index " + errorIndex + ", text " + string);
                    }
                } else {
                    Logger.debug("SNMP timeout");
                }
            }
            snmp.close();
        }
        catch (IOException e) {
            Logger.debug("SNMP request failed", e);
        }
        return oid;
    }

    public static void inferProperties(Device d) {
        Scheduler.execute(() -> {
            HashMap<String, String> m = null;
            for (NetworkIF nif : d.getInterfaces()) {
                m = SNMP.getValues(nif.getAddress());
                if (m == null) continue;
                SNMP.inferProperties(nif);
                break;
            }
            if (m == null) {
                return;
            }
            d.setName((String)m.get("Name"));
            d.setDescription((String)m.get("Descr"));
        });
    }

    public static void inferProperties(NetworkIF nif) {
        HashMap<String, String> m = SNMP.getValues(nif.getAddress());
        if (m == null) {
            return;
        }
        try {
            if (m.get("IF-speed") != null) {
                nif.getConnection().setBandwidth(Double.valueOf((String)m.get("IF-speed")) / 1000000.0);
            }
        }
        catch (Exception e) {
            Logger.warn("Unable to set interface speed", e);
        }
        if (m.get("MAC-address") != null && nif instanceof PhysicalIF) {
            ((PhysicalIF)nif).setMacAddress((String)m.get("MAC-address"));
        }
    }

    private static Properties loadMIB() {
        return IO.getMergedProps("/MIB");
    }
}

