/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.model.IF;

import ch.rakudave.jnetmap.model.Connection;
import ch.rakudave.jnetmap.model.IF.NetworkIF;
import ch.rakudave.jnetmap.model.IF.PhysicalIF;
import ch.rakudave.jnetmap.model.device.Device;
import ch.rakudave.jnetmap.net.Subnet;
import ch.rakudave.jnetmap.net.status.Status;
import ch.rakudave.jnetmap.util.Tuple;
import com.thoughtworks.xstream.annotations.XStreamAlias;
import java.net.InetAddress;
import java.util.Date;
import java.util.LinkedList;

@XStreamAlias(value="RepeaterIF")
public class TransparentIF
implements NetworkIF {
    private String name = "";
    private Device device;
    private Connection connection;
    private NetworkIF counterpart;
    private boolean useDevice;
    private Status status = Status.UNKNOWN;

    public TransparentIF() {
    }

    public TransparentIF(Device parent, Connection connection, NetworkIF counterpart) {
        this.device = parent;
        this.connection = connection;
        this.setCounterpart(counterpart);
        this.name = "Port " + (parent.getInterfaces().size() + 1);
    }

    @Override
    public InetAddress getAddress() {
        return null;
    }

    @Override
    public String getCanonicalName() {
        return "";
    }

    public NetworkIF getCounterpart() {
        return this.counterpart;
    }

    @Override
    public Device getDevice() {
        return this.device;
    }

    @Override
    public InetAddress getGateway() {
        return null;
    }

    @Override
    public Date getLastSeen() {
        return this.counterpart.getLastSeen();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    @Override
    public Subnet getSubnet() {
        return null;
    }

    @Override
    public boolean setAddress(String addr) {
        return true;
    }

    public void setCounterpart(NetworkIF nif) {
        if (nif == null) {
            return;
        }
        this.counterpart = nif;
        if (!(nif instanceof PhysicalIF)) {
            this.useDevice = true;
        }
    }

    @Override
    public boolean setGateway(String gateway) {
        return true;
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            this.name = name;
        }
    }

    @Override
    public boolean setSubnet(String subnet) {
        return true;
    }

    public String toString() {
        return this.name + ": transparent";
    }

    @Override
    public String toHtmlString() {
        return "<span style=\"color: " + this.getStatus().getHtmlValue() + "\">" + this.toString() + "</span>";
    }

    @Override
    public void updateStatus() {
        Status newStatus;
        Status status = newStatus = this.useDevice ? this.counterpart.getDevice().getStatus() : this.counterpart.getStatus();
        if (!this.status.equals((Object)newStatus)) {
            this.status = newStatus;
            this.connection.setStatus(this, this.status);
        }
    }

    @Override
    public Connection getConnection() {
        return this.connection;
    }

    @Override
    public LinkedList<Tuple<Date, Status>> getStatusHistory() {
        return this.counterpart.getStatusHistory();
    }

    @Override
    public void addStatusUnknownToHistory() {
    }

    @Override
    public long getLatency() {
        return this.counterpart.getLatency();
    }

    public void setDevice(Device device) {
        this.device = device;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }
}

