/*
 * Decompiled with CFR 0.152.
 */
package ch.rakudave.jnetmap.controller.command;

import ch.rakudave.jnetmap.controller.command.Command;
import ch.rakudave.jnetmap.controller.command.CommandListener;
import ch.rakudave.jnetmap.util.Settings;
import ch.rakudave.jnetmap.util.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public final class CommandHistory {
    private List<CommandListener> listeners = new ArrayList<CommandListener>();
    private LinkedList<Command> done = new LinkedList();
    private LinkedList<Command> undone = new LinkedList();

    public Object execute(Command c) {
        try {
            Object result = c.redo();
            this.done.addFirst(c);
            this.undone.clear();
            if (this.done.size() > Settings.getInt("commandhistory.size", 20)) {
                this.done.removeLast();
            }
            this.listeners.forEach(l -> l.executed(c));
            return result;
        }
        catch (Exception e) {
            Logger.error("Unable to execute command", e);
            return null;
        }
    }

    public boolean canRedo() {
        return this.undone.size() > 0;
    }

    public Object redo() {
        if (!this.canRedo()) {
            return null;
        }
        try {
            Command c = this.undone.getFirst();
            Object result = c.redo();
            this.undone.removeFirst();
            this.done.addFirst(c);
            this.listeners.forEach(l -> l.redone(c));
            return result;
        }
        catch (Exception e) {
            Logger.error("Unable to redo command", e);
            return null;
        }
    }

    public int getRedoSize() {
        return this.undone.size();
    }

    public boolean canUndo() {
        return this.done.size() > 0;
    }

    public Object undo() {
        if (!this.canUndo()) {
            return null;
        }
        try {
            Command c = this.done.getFirst();
            Object result = c.undo();
            this.done.removeFirst();
            this.undone.addFirst(c);
            this.listeners.forEach(l -> l.undone(c));
            return result;
        }
        catch (Exception e) {
            Logger.error("Unable to undo command", e);
            return null;
        }
    }

    public int getUndoSize() {
        return this.done.size();
    }

    public Vector<Command> getCommands() {
        Vector<Command> result = new Vector<Command>();
        result.addAll(this.undone);
        Collections.reverse(result);
        result.addAll(this.done);
        return result;
    }

    public void addCommandListener(CommandListener listener) {
        this.listeners.add(listener);
    }

    public void removeCommandListener(CommandListener listener) {
        this.listeners.remove(listener);
    }
}

