## Command assemble ##

If you have installed [`keystone`](http://www.keystone-engine.org/), then `gef`
will provide a convenient command to assemble native instructions directly to
opcodes of the architecture you are currently debugging.

Call it via `assemble` or its alias `asm`:

```
gef➤ asm [INSTRUCTION [; INSTRUCTION ...]]
```

![gef-assemble](https://i.imgur.com/ShuPF6h.png)

By setting the `--arch ARCH` and `--mode MODE` the target platform for the
assembly can be changed. Available architectures and modes can be displayed
with `--list-archs`.

```
gef➤ asm --list-archs
Available architectures/modes (with endianness):
- ARM
  * ARM     (little, big)
  * THUMB   (little, big)
  * ARMV8   (little, big)
  * THUMBV8 (little, big)
- ARM64
  * AARCH64 (little)
- MIPS
  * MIPS32  (little, big)
  * MIPS64  (little, big)
- PPC
  * PPC32   (big)
  * PPC64   (little, big)
- SPARC
  * SPARC32 (little, big)
  * SPARC64 (big)
- SYSTEMZ
  * SYSTEMZ (little, big)
- X86
  * 16      (little)
  * 32      (little)
  * 64      (little)
```

```
gef➤ asm --arch x86 --mode 32 [INSTRUCTION [; INSTRUCTION ...]]
gef➤ asm --arch arm [INSTRUCTION [; INSTRUCTION ...]]
```

To choose the endianness use `--endian ENDIANNESS` (by default, `little`):

```
gef➤ asm --endian big [INSTRUCTION [; INSTRUCTION ...]]
```

Using the `--overwrite-location LOCATION` option, `gef` will write the assembly
code generated by `keystone` directly to the memory location specified. This
makes it extremely convenient to simply overwrite opcodes.

![gef-assemble-overwrite](https://i.imgur.com/BsbGXNC.png)

Another convenient option is `--as-shellcode` which outputs the generated
shellcode as an escaped python string. It can then easily be used in your
python scripts.

![gef-assemble-shellcode](https://i.imgur.com/E2fpFuH.png)
