Empire 3.1 RESTful API introduced a new set of commands for scripting and controlling Empire through HTTP JSON requests.

This API and documentation are based on the excellent example set by the [BeEF Project](https://github.com/beefproject/beef/wiki/BeEF-RESTful-API). All credit to [@antisnatchor](https://github.com/antisnatchor) and the entire BeEF community for the great examples to draw on.

* [Introduction](#introduction)
* [API Authentication](#api-authentication)
* [Version Information](#version-information)
* [Configuration Information](#configuration-information)
* [[Admin Functionality|Admin-Functionality]]
* [[User Management|User-Management]]
* [[Listeners|Listeners]]
* [[Stagers|Stagers]]
* [[Agents|Agents]]
* [[Modules|Modules]]
* [[Credentials|Credentials]]
* [[Reporting|Reporting]]


## Introduction

There are currently two ways to launch the Empire RESTful API.

You can start a normal Empire instance with `./empire`, and then in another windows run `./empire --rest`. This starts the API without a fully-featured Empire instance, allowing you to still interact with the normal Empire UI.

Alternatively, you can run Empire 'headless' with `./empire --headless`, which will start a complete Empire instance as well as the RESTful API, and will suppress all output except for startup messages.

By default, the RESTful API is started on port 1337, over HTTPS using the certificate located at ./data/empire.pem (which can be generated with ./setup/cert.sh). This port can be changed by supplying `--restport <PORT_NUM>` on launch.

The default username for the API is 'empireadmin' and the default password is randomly generated by ./setup/setup_database.py during install. This value is retrievable by using `sqlitebrowser ./data/empire.db`, or can be modified in the setup_database.py file. You can also manually specify the username and password for a REST/headless launch with `--username admin --password 'Password123!'`.

You can review all cli options by running:
```bash
# ./empire -h
usage: empire [-h] [--debug [DEBUG]] [-s [STAGER]]
              [-o [STAGER_OPTIONS [STAGER_OPTIONS ...]]] [-l [LISTENER]] [-v]
              [--rest] [--restport [RESTPORT]] [--headless]
              [--username [USERNAME]] [--password [PASSWORD]]

optional arguments:
  -h, --help            show this help message and exit
  --debug [DEBUG]       Debug level for output (default of 1).
  -s [STAGER], --stager [STAGER]
                        Specify a stager to generate. Lists all stagers if
                        none is specified.
  -o [STAGER_OPTIONS [STAGER_OPTIONS ...]], --stager-options [STAGER_OPTIONS [STAGER_OPTIONS ...]]
                        Supply options to set for a stager in OPTION=VALUE
                        format. Lists options if nothing is specified.
  -l [LISTENER], --listener [LISTENER]
                        Display listener options. Displays all listeners if
                        nothing is specified.
  -v, --version         Display current Empire version.
  --rest                Run the Empire RESTful API.
  --restport [RESTPORT]
                        Port to run the Empire RESTful API on.
  --headless            Run Empire and the RESTful API headless without the
                        usual interface.
  --username [USERNAME]
                        Start the RESTful API with the specified username
                        instead of pulling from empire.db
  --password [PASSWORD]
                        Start the RESTful API with the specified password
                        instead of pulling from empire.db
```

## API Authentication

The Empire API uses a simple token-based auth system similar to [BeEF's](https://github.com/beefproject/beef/wiki/BeEF-RESTful-API#authentication). In order to make any requests to the API, a **?token=X** parameter must be supplied, otherwise a 403 error is returned.

The token is randomly generated on rest API start up and displayed on the command line:
```bash
# ./empire --rest --password 'Password123!'

[*] Loading modules from: /mnt/hgfs/git/github/Empire/lib/modules/
 * Starting Empire RESTful API on port: 1337
 * RESTful API token: ks23jlvdki4fj1j23w39h0h0xcuwjrqilocxd6b5
 * Running on https://0.0.0.0:1337/ (Press CTRL+C to quit)
```

To retrieve the session token through the login interface, you can POST a request to `/api/admin/login`. Here's an example with curl:
```bash
# curl --insecure -i -H "Content-Type: application/json" https://localhost:1337/api/admin/login -X POST -d '{"username":"empireadmin", "password":"Password123!"}'
HTTP/1.0 200 OK
Content-Type: application/json
Content-Length: 57
Server: Werkzeug/0.11.4
Date: Thu, 31 Mar 2016 23:38:59 GMT

{
  "token": "ks23jlvdki4fj1j23w39h0h0xcuwjrqilocxd6b5"
}
```


## Version Information

### Handler

* **Handler** : GET /api/version
* Description : Returns the current Empire version.
* No parameters

### Example

**Request**:
```bash
curl --insecure -i https://localhost:1337/api/version?token=ks23jlvdki4fj1j23w39h0h0xcuwjrqilocxd6b5
```

**Response**:
```json
{
  "version": "1.5.0"
}
```
## Map Information

### Handler

* **Handler** : GET /api/map
* Description : Returns list of all API routes.
* No parameters

### Example

**Request**:
```bash
curl --insecure -i https://localhost:1337/api/map?token=ks23jlvdki4fj1j23w39h0h0xcuwjrqilocxd6b5
```

**Response**:


## Configuration Information

### Handler

* **Handler** : GET /api/config
* Description : Returns the current Empire configuration.
* No parameters

### Example

**Request**:
```bash
curl --insecure -i https://localhost:1337/api/config?token=ks23jlvdki4fj1j23w39h0h0xcuwjrqilocxd6b5
```

**Response**:
```json
{
  "config": [
    {
      "api_password": "C3>Jl...",
      "api_username": "empireadmin",
      "autorun_command": "",
      "autorun_data": "",
      "current_api_token": "ks23jlvdki4fj1j23w39h0h0xcuwjrqilocxd6b5",
      "default_cert_path": "",
      "default_delay": 5,
      "default_jitter": 0.0,
      "default_lost_limit": 60,
      "default_port": "8080",
      "default_profile": "/admin/get.php,/news.asp,/login/process.jsp|Mozilla/5.0 (Windows NT 6.1; WOW64; Trident/7.0; rv:11.0) like Gecko",
      "install_path": "/home/user/Empire/",
      "ip_blacklist": "",
      "ip_whitelist": "",
      "permanent_api_token": "gi5afo3umac6...",
      "server_version": "Microsoft-IIS/7.5",
      "stage0_uri": "index.asp",
      "stage1_uri": "index.jsp",
      "stage2_uri": "index.php",
      "staging_key": "m@T%L?VH...",
      "version": "1.5.0"
    }
  ]
}
```