/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin.proxy;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.logging.Logger;
import org.owasp.webscarab.model.HttpUrl;
import org.owasp.webscarab.plugin.proxy.ConnectionHandler;
import org.owasp.webscarab.plugin.proxy.NetworkSimulator;
import org.owasp.webscarab.plugin.proxy.Proxy;
import org.owasp.webscarab.util.W32WinInet;

public class Listener
implements Runnable {
    private Proxy _proxy;
    private String _address;
    private int _port;
    private HttpUrl _base = null;
    private NetworkSimulator _simulator = null;
    private boolean _usePlugins = false;
    private boolean _primaryProxy = false;
    private ServerSocket _serversocket = null;
    private boolean _stop = false;
    private boolean _stopped = true;
    private InetAddress _addr;
    private int _count = 1;
    private Logger _logger = Logger.getLogger(this.getClass().getName());

    public Listener(Proxy proxy, String address, int port) throws IOException {
        this._proxy = proxy;
        if (address == null) {
            address = "*";
        }
        this._address = address;
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("port must be between 0 and 65536");
        }
        this._port = port;
        this._addr = this._address.equals("") || this._address.equals("*") ? null : InetAddress.getByName(this._address);
        this._serversocket = new ServerSocket(this._port, 5, this._addr);
        this._serversocket.close();
    }

    @Override
    public void run() {
        this._stop = false;
        this._stopped = false;
        if (this._serversocket == null || this._serversocket.isClosed()) {
            try {
                this.listen();
            }
            catch (IOException ioe) {
                this._logger.severe("Can't listen at " + this.getKey() + ": " + ioe);
                this._stopped = true;
                return;
            }
        }
        if (W32WinInet.isAvailable() && this._primaryProxy) {
            W32WinInet.interceptProxy("localhost", this._port);
        }
        while (!this._stop) {
            try {
                Socket sock = this._serversocket.accept();
                InetAddress address = sock.getInetAddress();
                ConnectionHandler ch = new ConnectionHandler(this._proxy, sock, this._base, this._simulator, this._usePlugins);
                Thread thread = new Thread((Runnable)ch, String.valueOf(Thread.currentThread().getName()) + "-" + Integer.toString(this._count++));
                thread.setDaemon(true);
                thread.start();
            }
            catch (IOException e) {
                if (e.getMessage().equals("Accept timed out")) continue;
                System.err.println("I/O error while waiting for a connection : " + e.getMessage());
            }
        }
        this._stopped = true;
        try {
            this._serversocket.close();
        }
        catch (IOException ioe) {
            System.err.println("Error closing socket : " + ioe);
        }
        if (W32WinInet.isAvailable() && this._primaryProxy) {
            W32WinInet.revertProxy();
        }
        this._logger.info("Not listening on " + this.getKey());
    }

    private void listen() throws IOException {
        this._serversocket = new ServerSocket(this._port, 5, this._addr);
        this._logger.info("Proxy listening on " + this.getKey());
        try {
            this._serversocket.setSoTimeout(100);
        }
        catch (SocketException se) {
            this._logger.warning("Error setting sockettimeout " + se);
            this._logger.warning("It is likely that this listener will be unstoppable!");
        }
    }

    public boolean stop() {
        this._stop = true;
        if (!this._stopped) {
            int i = 0;
            while (i < 20) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this._stopped) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        return true;
    }

    public String getAddress() {
        return this._address;
    }

    public int getPort() {
        return this._port;
    }

    public void setBase(HttpUrl base) {
        this._base = base;
    }

    public HttpUrl getBase() {
        return this._base;
    }

    public void setSimulator(NetworkSimulator simulator) {
        this._simulator = simulator;
    }

    public NetworkSimulator getSimulator() {
        return this._simulator;
    }

    public void usePlugins(boolean usePlugins) {
        this._usePlugins = usePlugins;
    }

    public boolean usesPlugins() {
        return this._usePlugins;
    }

    public void setPrimaryProxy(boolean primary) {
        this._primaryProxy = primary;
    }

    public boolean isPrimaryProxy() {
        return this._primaryProxy;
    }

    public String getKey() {
        return String.valueOf(this._address) + ":" + this._port;
    }
}

