/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.plugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.owasp.webscarab.httpclient.HTTPClientFactory;
import org.owasp.webscarab.model.ConversationID;
import org.owasp.webscarab.model.FrameworkModel;
import org.owasp.webscarab.model.Preferences;
import org.owasp.webscarab.model.Request;
import org.owasp.webscarab.model.Response;
import org.owasp.webscarab.model.StoreException;
import org.owasp.webscarab.plugin.CredentialManager;
import org.owasp.webscarab.plugin.FrameworkUI;
import org.owasp.webscarab.plugin.Hook;
import org.owasp.webscarab.plugin.Plugin;
import org.owasp.webscarab.plugin.ScriptableConversation;

public class Framework {
    private List _plugins = new ArrayList();
    private List _analysisQueue = new LinkedList();
    private FrameworkModel _model;
    private Logger _logger = Logger.getLogger(this.getClass().getName());
    private String _version;
    private FrameworkUI _ui = null;
    private CredentialManager _credentialManager;
    private AddConversationHook _allowAddConversation;
    private Hook _analyseConversation;
    private Thread _queueThread = null;
    private QueueProcessor _qp = null;
    private Pattern dropPattern = null;

    public Framework() {
        this._model = new FrameworkModel();
        this._allowAddConversation = new AddConversationHook();
        this._credentialManager = new CredentialManager();
        this.configureHTTPClient();
        String dropRegex = Preferences.getPreference("WebScarab.dropRegex", null);
        if (dropRegex != null) {
            try {
                this.dropPattern = Pattern.compile(dropRegex);
            }
            catch (PatternSyntaxException pse) {
                this._logger.warning("Got an invalid regular expression for conversations to ignore: " + dropRegex + " results in " + pse.toString());
            }
        }
        this._qp = new QueueProcessor();
        this._queueThread = new Thread((Runnable)this._qp, "QueueProcessor");
        this._queueThread.setDaemon(true);
        this._queueThread.setPriority(1);
        this._queueThread.start();
    }

    public CredentialManager getCredentialManager() {
        return this._credentialManager;
    }

    public void setUI(FrameworkUI ui) {
        this._ui = ui;
    }

    public void setSession(String type, Object store, String session) throws StoreException {
        this._model.setSession(type, store, session);
        for (Plugin plugin : this._plugins) {
            if (!plugin.isRunning()) {
                plugin.setSession(type, store, session);
                continue;
            }
            this._logger.warning(String.valueOf(plugin.getPluginName()) + " is running while we are setting the session");
        }
    }

    public FrameworkModel getModel() {
        return this._model;
    }

    private void extractVersionFromManifest() {
        Package pkg = Package.getPackage("org.owasp.webscarab");
        if (pkg != null) {
            this._version = pkg.getImplementationVersion();
        } else {
            this._logger.severe("PKG is null");
        }
        if (this._version == null) {
            this._version = "unknown (local build?)";
        }
    }

    public void addPlugin(Plugin plugin) {
        this._plugins.add(plugin);
        Hook[] hooks = plugin.getScriptingHooks();
    }

    public Plugin getPlugin(String name) {
        Plugin plugin2 = null;
        for (Plugin plugin2 : this._plugins) {
            if (!plugin2.getPluginName().equals(name)) continue;
            return plugin2;
        }
        return null;
    }

    public void startPlugins() {
        HTTPClientFactory.getInstance().getSSLContextManager().invalidateSessions();
        for (Plugin plugin : this._plugins) {
            if (!plugin.isRunning()) {
                Thread t = new Thread((Runnable)plugin, plugin.getPluginName());
                t.setDaemon(true);
                t.start();
                continue;
            }
            this._logger.warning(String.valueOf(plugin.getPluginName()) + " was already running");
        }
    }

    public boolean isBusy() {
        for (Plugin plugin : this._plugins) {
            if (!plugin.isBusy()) continue;
            return true;
        }
        return false;
    }

    public boolean isRunning() {
        for (Plugin plugin : this._plugins) {
            if (!plugin.isRunning()) continue;
            return true;
        }
        return false;
    }

    public boolean isModified() {
        if (this._model.isModified()) {
            return true;
        }
        for (Plugin plugin : this._plugins) {
            if (!plugin.isModified()) continue;
            return true;
        }
        return false;
    }

    public String[] getStatus() {
        ArrayList<String> status = new ArrayList<String>();
        for (Plugin plugin : this._plugins) {
            status.add(String.valueOf(plugin.getPluginName()) + " : " + plugin.getStatus());
        }
        return status.toArray(new String[0]);
    }

    public boolean stopPlugins() {
        if (this.isBusy()) {
            return false;
        }
        for (Plugin plugin : this._plugins) {
            if (plugin.isRunning()) {
                plugin.stop();
                continue;
            }
            this._logger.warning(String.valueOf(plugin.getPluginName()) + " was not running");
        }
        return true;
    }

    public void saveSessionData() throws StoreException {
        StoreException storeException = null;
        if (this._model.isModified()) {
            this._logger.info("Flushing model");
            this._model.flush();
            this._logger.info("Done");
        }
        for (Plugin plugin : this._plugins) {
            if (!plugin.isModified()) continue;
            try {
                this._logger.info("Flushing " + plugin.getPluginName());
                plugin.flush();
                this._logger.info("Done");
            }
            catch (StoreException se) {
                if (storeException == null) {
                    storeException = se;
                }
                this._logger.severe("Error saving data for " + plugin.getPluginName() + ": " + se);
            }
        }
        if (storeException != null) {
            throw storeException;
        }
    }

    public String getVersion() {
        return this._version;
    }

    public ConversationID reserveConversationID() {
        return this._model.reserveConversationID();
    }

    public void addConversation(ConversationID id, Request request, Response response, String origin) {
        this.addConversation(id, new Date(), request, response, origin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConversation(ConversationID id, Date when, Request request, Response response, String origin) {
        ScriptableConversation conversation = new ScriptableConversation(request, response, origin);
        if (conversation.isCancelled()) {
            return;
        }
        if (this.dropPattern != null && this.dropPattern.matcher(request.getURL().toString()).matches()) {
            return;
        }
        this._model.addConversation(id, when, request, response, origin);
        if (!conversation.shouldAnalyse()) {
            return;
        }
        List list = this._analysisQueue;
        synchronized (list) {
            this._analysisQueue.add(id);
        }
    }

    public ConversationID addConversation(Request request, Response response, String origin) {
        ConversationID id = this.reserveConversationID();
        this.addConversation(id, new Date(), request, response, origin);
        return id;
    }

    private void configureHTTPClient() {
        HTTPClientFactory factory = HTTPClientFactory.getInstance();
        String prop = null;
        try {
            prop = "WebScarab.httpProxy";
            String value = Preferences.getPreference(prop);
            if (value == null || value.equals("")) {
                value = ":3128";
            }
            int colon = value.indexOf(":");
            factory.setHttpProxy(value.substring(0, colon), Integer.parseInt(value.substring(colon + 1).trim()));
            prop = "WebScarab.httpsProxy";
            value = Preferences.getPreference(prop);
            if (value == null || value.equals("")) {
                value = ":3128";
            }
            colon = value.indexOf(":");
            factory.setHttpsProxy(value.substring(0, colon), Integer.parseInt(value.substring(colon + 1).trim()));
            prop = "WebScarab.noProxy";
            value = Preferences.getPreference(prop, "");
            if (value == null) {
                value = "";
            }
            factory.setNoProxy(value.split(" *, *"));
            int connectTimeout = 30000;
            prop = "HttpClient.connectTimeout";
            value = Preferences.getPreference(prop, "");
            if (value != null && !value.equals("")) {
                try {
                    connectTimeout = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            int readTimeout = 0;
            prop = "HttpClient.readTimeout";
            value = Preferences.getPreference(prop, "");
            if (value != null && !value.equals("")) {
                try {
                    readTimeout = Integer.parseInt(value);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            factory.setTimeouts(connectTimeout, readTimeout);
        }
        catch (NumberFormatException nfe) {
            this._logger.warning("Error parsing property " + prop + ": " + nfe);
        }
        catch (Exception e) {
            this._logger.warning("Error configuring the HTTPClient property " + prop + ": " + e);
        }
        factory.setAuthenticator(this._credentialManager);
    }

    private class AddConversationHook
    extends Hook {
        public AddConversationHook() {
            super("Add Conversation", "Called when a new conversation is added to the framework.\nUse conversation.setCancelled(boolean) and conversation.setAnalyse(boolean) after deciding using conversation.getRequest() and conversation.getResponse()");
        }
    }

    private class QueueProcessor
    implements Runnable {
        private QueueProcessor() {
        }

        @Override
        public void run() {
        }
    }
}

