/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.owasp.webscarab.model.Message;
import org.owasp.webscarab.model.Request;

public class MultiPartContent {
    private byte[] _boundary;
    private List _parts;
    private static final byte[] CRLF = new byte[]{13, 10};

    public MultiPartContent(String contentType, byte[] content) {
        block8: {
            try {
                this._parts = new ArrayList();
                if (contentType != null && contentType.trim().startsWith("multipart/form-data")) {
                    int pos = contentType.indexOf("boundary=");
                    int semi = contentType.indexOf(";", pos);
                    if (semi < 0) {
                        semi = contentType.length();
                    }
                    this._boundary = ("--" + contentType.substring(pos + 9, semi).trim()).getBytes("UTF-8");
                } else {
                    this._boundary = null;
                }
                if (this._boundary == null) break block8;
                int start = this.findBytes(content, this._boundary, 0) + this._boundary.length + CRLF.length;
                int end = this.findBytes(content, this._boundary, start);
                while (end < content.length) {
                    Message message = new Message();
                    try {
                        message.read(new ByteArrayInputStream(content, start, end - start - CRLF.length));
                    }
                    catch (IOException ioe) {
                        System.err.println("IOException on a ByteArrayInputStream should never happen! " + ioe);
                    }
                    this._parts.add(message);
                    start = end + this._boundary.length + CRLF.length;
                    end = this.findBytes(content, this._boundary, start);
                }
            }
            catch (UnsupportedEncodingException e) {
                System.err.println("UTF-8 not supported?! " + e);
            }
        }
    }

    public boolean verifyBoundary() {
        return true;
    }

    public String getBoundary() {
        try {
            return new String(this._boundary, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("UTF-8 not supported?! " + e);
            return null;
        }
    }

    public int size() {
        return this._parts.size();
    }

    public Message set(int index, Message part) {
        return this._parts.set(index, part);
    }

    public Message get(int index) {
        return (Message)this._parts.get(index);
    }

    public Message remove(int index) {
        return (Message)this._parts.remove(index);
    }

    public void add(int index, Message part) {
        this._parts.add(index, part);
    }

    public boolean add(Message part) {
        return this._parts.add(part);
    }

    private int findBytes(byte[] source, byte[] find, int start) {
        int matches = 0;
        int pos = start;
        while (pos < source.length && matches < find.length) {
            if (source[pos + matches] == find[matches]) {
                ++matches;
                continue;
            }
            matches = 0;
            ++pos;
        }
        return pos;
    }

    /*
     * Unable to fully structure code
     */
    private String readLine(InputStream is) throws IOException {
        if (is == null) {
            npe = new NullPointerException("InputStream may not be null!");
            npe.printStackTrace();
            throw npe;
        }
        line = new StringBuffer();
        c = '\u0000';
        i = is.read();
        if (i != -1) ** GOTO lbl13
        return null;
lbl-1000:
        // 1 sources

        {
            c = (char)(i & 255);
            line = line.append(c);
            i = is.read();
lbl13:
            // 2 sources

            ** while (i > -1 && i != 10 && i != 13)
        }
lbl14:
        // 1 sources

        if (i == 13) {
            i = is.read();
        }
        return line.toString();
    }

    public String getPartName(int index) {
        String name;
        int nameindex;
        Message part = (Message)this._parts.get(index);
        String disposition = part.getHeader("Content-Disposition");
        int semi = disposition.indexOf(";", nameindex = disposition.indexOf("name="));
        if (semi < 0) {
            semi = disposition.length();
        }
        if ((name = disposition.substring(nameindex + 5, semi).trim()).startsWith("\"") && name.endsWith("\"") || name.startsWith("\"") && name.endsWith("\"")) {
            name = name.substring(1, name.length() - 1);
        }
        return name;
    }

    public byte[] getBytes() {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            baos.write(this._boundary);
            baos.write(CRLF);
            for (Message message : this._parts) {
                message.write(baos);
                baos.write(CRLF);
                baos.write(this._boundary);
                baos.write(CRLF);
            }
            return baos.toByteArray();
        }
        catch (IOException ioe) {
            System.err.println("Shouldn't happen!! " + ioe);
            return null;
        }
    }

    public static void main(String[] args) {
        Request request = new Request();
        try {
            FileInputStream fis = new FileInputStream("/home/rogan/csob/3/conversations/4-request");
            request.read(fis);
            MultiPartContent mpc = new MultiPartContent(request.getHeader("Content-Type"), request.getContent());
            System.out.println("Got " + mpc.size());
            Message message = mpc.get(0);
            System.out.println("First part is " + message.getHeader("Content-Disposition") + " = '" + new String(message.getContent()) + "'");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

