/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.owasp.webscarab.httpclient.ChunkedInputStream;
import org.owasp.webscarab.httpclient.ChunkedOutputStream;
import org.owasp.webscarab.httpclient.FixedLengthInputStream;
import org.owasp.webscarab.model.NamedValue;

public class Message {
    private ArrayList _headers = null;
    private NamedValue[] NO_HEADERS = new NamedValue[0];
    private static final byte[] NO_CONTENT = new byte[0];
    InputStream _contentStream = null;
    ByteArrayOutputStream _content = null;
    boolean _chunked = false;
    boolean _gzipped = false;
    int _length = -1;
    protected Logger _logger = Logger.getLogger(this.getClass().getName());

    public void read(InputStream is) throws IOException {
        this._headers = null;
        String previous = null;
        String line = null;
        do {
            line = this.readLine(is);
            this._logger.finer("Header: " + line);
            if (line.startsWith(" ")) {
                if (previous == null) {
                    this._logger.severe("Got a continuation header but had no previous header line");
                    continue;
                }
                previous = String.valueOf(previous.trim()) + " " + line.trim();
                continue;
            }
            if (previous != null) {
                String[] pair = previous.split(":", 2);
                if (pair.length == 2) {
                    this.addHeader(new NamedValue(pair[0], pair[1].trim()));
                } else {
                    this._logger.warning("Error parsing header: '" + previous + "'");
                }
            }
            previous = line;
        } while (!line.equals(""));
        this._contentStream = is;
        if (this._chunked) {
            this._contentStream = new ChunkedInputStream(this._contentStream);
        } else if (this._length > -1) {
            this._contentStream = new FixedLengthInputStream(this._contentStream, this._length);
        }
    }

    public void write(OutputStream os) throws IOException {
        this.write(os, "\r\n");
    }

    public void write(OutputStream os, String crlf) throws IOException {
        if (this._headers != null) {
            int i = 0;
            while (i < this._headers.size()) {
                NamedValue nv = (NamedValue)this._headers.get(i);
                os.write(new String(String.valueOf(nv.getName()) + ": " + nv.getValue() + crlf).getBytes());
                this._logger.finest("Header: " + nv);
                ++i;
            }
        }
        os.write(crlf.getBytes());
        this._logger.finer("wrote headers");
        if (this._chunked) {
            os = new ChunkedOutputStream(os);
        }
        if (this._contentStream != null) {
            this._logger.finer("Flushing contentStream");
            this.flushContentStream(os);
            this._logger.finer("Done flushing contentStream");
        } else if (this._content != null && this._content.size() > 0) {
            this._logger.finer("Writing content bytes");
            os.write(this._content.toByteArray());
            this._logger.finest("Content: \n" + new String(this._content.toByteArray()));
            this._logger.finer("Done writing content bytes");
        }
        if (this._chunked) {
            ((ChunkedOutputStream)os).writeTrailer();
        }
    }

    public void parse(StringBuffer buffer) throws ParseException {
        this._headers = null;
        String previous = null;
        String line = null;
        do {
            if ((line = this.getLine(buffer)).startsWith(" ")) {
                if (previous == null) {
                    this._logger.severe("Got a continuation header but had no previous header line");
                    continue;
                }
                previous = String.valueOf(previous.trim()) + " " + line.trim();
                continue;
            }
            if (previous != null) {
                String[] pair = previous.split(":", 2);
                if (pair.length == 2) {
                    this.addHeader(new NamedValue(pair[0], pair[1].trim()));
                } else {
                    this._logger.warning("Error parsing header: '" + previous + "'");
                }
            }
            previous = line;
        } while (!line.equals(""));
        this._content = new ByteArrayOutputStream();
        try {
            this._content.write(buffer.toString().getBytes());
        }
        catch (IOException pair) {
            // empty catch block
        }
        String cl = this.getHeader("Content-length");
        if (cl != null) {
            this.setHeader(new NamedValue("Content-length", Integer.toString(this._content.size())));
        }
    }

    public String toString() {
        return this.toString("\r\n");
    }

    public String toString(String crlf) {
        StringBuffer buff = new StringBuffer();
        if (this._headers != null) {
            int i = 0;
            while (i < this._headers.size()) {
                NamedValue nv = (NamedValue)this._headers.get(i);
                if (nv.getName().equalsIgnoreCase("Transfer-Encoding") && nv.getValue().indexOf("chunked") > -1) {
                    buff.append("X-" + nv.getName() + ": " + nv.getValue() + crlf);
                } else if (nv.getName().equalsIgnoreCase("Content-Encoding") && nv.getValue().indexOf("gzip") > -1) {
                    buff.append("X-" + nv.getName() + ": " + nv.getValue() + crlf);
                } else {
                    buff.append(String.valueOf(nv.getName()) + ": " + nv.getValue() + crlf);
                }
                ++i;
            }
        }
        byte[] content = this.getContent();
        if (this._chunked && content != null) {
            buff.append("Content-length: " + Integer.toString(content.length) + crlf);
        }
        buff.append(crlf);
        if (content != null) {
            try {
                buff.append(new String(content, "UTF-8"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return buff.toString();
    }

    private void updateFlagsForHeader(NamedValue header) {
        if (header.getName().equalsIgnoreCase("Transfer-Encoding")) {
            this._chunked = header.getValue().indexOf("chunked") > -1;
        } else if (header.getName().equalsIgnoreCase("Content-Encoding")) {
            this._gzipped = header.getValue().indexOf("gzip") > -1;
        } else if (header.getName().equalsIgnoreCase("Content-length")) {
            try {
                this._length = Integer.parseInt(header.getValue().trim());
            }
            catch (NumberFormatException nfe) {
                this._logger.warning("Error parsing the content-length '" + header.getValue() + "' : " + nfe);
            }
        }
    }

    public void setHeader(String name, String value) {
        this.setHeader(new NamedValue(name, value.trim()));
    }

    public void setHeader(NamedValue header) {
        this.updateFlagsForHeader(header);
        if (this._headers == null) {
            this._headers = new ArrayList(1);
        } else {
            int i = 0;
            while (i < this._headers.size()) {
                NamedValue nv = (NamedValue)this._headers.get(i);
                if (nv.getName().equalsIgnoreCase(header.getName())) {
                    this._headers.set(i, header);
                    return;
                }
                ++i;
            }
        }
        this._headers.add(header);
    }

    public void addHeader(String name, String value) {
        this.addHeader(new NamedValue(name, value.trim()));
    }

    public void addHeader(NamedValue header) {
        this.updateFlagsForHeader(header);
        if (this._headers == null) {
            this._headers = new ArrayList(1);
        }
        this._headers.add(header);
    }

    public String deleteHeader(String name) {
        if (this._headers == null) {
            return null;
        }
        int i = 0;
        while (i < this._headers.size()) {
            NamedValue nv = (NamedValue)this._headers.get(i);
            if (nv.getName().equalsIgnoreCase(name)) {
                this._headers.remove(i);
                this.updateFlagsForHeader(new NamedValue(name, ""));
                return nv.getValue();
            }
            ++i;
        }
        return null;
    }

    public String[] getHeaderNames() {
        if (this._headers == null || this._headers.size() == 0) {
            return new String[0];
        }
        String[] names = new String[this._headers.size()];
        int i = 0;
        while (i < this._headers.size()) {
            NamedValue nv = (NamedValue)this._headers.get(i);
            names[i] = nv.getName();
            ++i;
        }
        return names;
    }

    public String getHeader(String name) {
        if (this._headers == null) {
            return null;
        }
        int i = 0;
        while (i < this._headers.size()) {
            NamedValue nv = (NamedValue)this._headers.get(i);
            if (nv.getName().equalsIgnoreCase(name)) {
                return nv.getValue();
            }
            ++i;
        }
        return null;
    }

    public String[] getHeaders(String name) {
        if (this._headers == null) {
            return null;
        }
        ArrayList<String> values = new ArrayList<String>();
        int i = 0;
        while (i < this._headers.size()) {
            NamedValue nv = (NamedValue)this._headers.get(i);
            if (nv.getName().equalsIgnoreCase(name)) {
                values.add(nv.getValue());
            }
            ++i;
        }
        if (values.size() == 0) {
            return null;
        }
        return values.toArray(new String[0]);
    }

    public NamedValue[] getHeaders() {
        if (this._headers == null || this._headers.size() == 0) {
            return new NamedValue[0];
        }
        return this._headers.toArray(this.NO_HEADERS);
    }

    public void setHeaders(NamedValue[] headers) {
        if (this._headers == null) {
            this._headers = new ArrayList();
        } else {
            this._headers.clear();
        }
        int i = 0;
        while (i < headers.length) {
            this.addHeader(headers[i]);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected String readLine(InputStream is) throws IOException {
        if (is == null) {
            npe = new NullPointerException("InputStream may not be null!");
            npe.printStackTrace();
            throw npe;
        }
        line = new StringBuffer();
        c = '\u0000';
        i = is.read();
        if (i != -1) ** GOTO lbl13
        return null;
lbl-1000:
        // 1 sources

        {
            c = (char)(i & 255);
            line = line.append(c);
            i = is.read();
lbl13:
            // 2 sources

            ** while (i > -1 && i != 10 && i != 13)
        }
lbl14:
        // 1 sources

        if (i == 13) {
            i = is.read();
        }
        this._logger.finest(line.toString());
        return line.toString();
    }

    protected String getLine(StringBuffer buffer) {
        int lf = buffer.indexOf("\n");
        if (lf > -1) {
            int cr = buffer.indexOf("\r");
            if (cr == -1 || cr > lf) {
                cr = lf;
            }
            String line = buffer.substring(0, cr);
            buffer.delete(0, lf + 1);
            this._logger.finest("line is '" + line + "'");
            return line;
        }
        if (buffer.length() > 0) {
            String line = buffer.toString();
            buffer.setLength(0);
            this._logger.finest("line is '" + line + "'");
            return line;
        }
        return "";
    }

    public byte[] getContent() {
        try {
            this.flushContentStream(null);
        }
        catch (IOException ioe) {
            this._logger.info("IOException flushing the contentStream: " + ioe);
        }
        if (this._content != null && this._gzipped) {
            try {
                int got;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPInputStream gzis = new GZIPInputStream(new ByteArrayInputStream(this._content.toByteArray()));
                byte[] buff = new byte[1024];
                while ((got = gzis.read(buff)) > -1) {
                    baos.write(buff, 0, got);
                }
                return baos.toByteArray();
            }
            catch (IOException ioe) {
                this._logger.info("IOException unzipping content : " + ioe);
                return NO_CONTENT;
            }
        }
        if (this._content != null) {
            return this._content.toByteArray();
        }
        return NO_CONTENT;
    }

    public void flushContentStream() {
        try {
            this.flushContentStream(null);
        }
        catch (IOException ioe) {
            this._logger.info("Exception flushing the contentStream " + ioe);
        }
    }

    private void flushContentStream(OutputStream os) throws IOException {
        IOException ioe = null;
        if (this._contentStream == null) {
            return;
        }
        if (this._content == null) {
            this._content = new ByteArrayOutputStream();
        }
        byte[] buf = new byte[4096];
        this._logger.finest("Reading initial bytes from contentStream " + this._contentStream);
        int got = this._contentStream.read(buf);
        this._logger.finest("Got " + got + " bytes");
        while (got > 0) {
            this._content.write(buf, 0, got);
            if (os != null) {
                try {
                    os.write(buf, 0, got);
                }
                catch (IOException e) {
                    this._logger.info("IOException ioe writing to output stream : " + e);
                    this._logger.info("Had seen " + (this._content.size() - got) + " bytes, was writing " + got);
                    ioe = e;
                    os = null;
                }
            }
            got = this._contentStream.read(buf);
            this._logger.finest("Got " + got + " bytes");
        }
        this._contentStream = null;
        if (ioe != null) {
            throw ioe;
        }
    }

    public void setNoBody() {
        this._content = null;
        this._contentStream = null;
    }

    public void setContent(byte[] bytes) {
        try {
            this.flushContentStream(null);
        }
        catch (IOException ioe) {
            this._logger.info("IOException flushing the contentStream " + ioe);
        }
        if (this._gzipped) {
            try {
                this._content = new ByteArrayOutputStream();
                GZIPOutputStream gzos = new GZIPOutputStream(this._content);
                gzos.write(bytes);
                gzos.close();
            }
            catch (IOException ioe) {
                this._logger.info("IOException gzipping content : " + ioe);
            }
        } else {
            this._content = new ByteArrayOutputStream();
            try {
                this._content.write(bytes);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }
        String cl = this.getHeader("Content-length");
        if (cl != null) {
            this.setHeader(new NamedValue("Content-length", Integer.toString(this._content.size())));
        }
    }

    public boolean equals(Object obj) {
        NamedValue[] thoseHeaders;
        if (!(obj instanceof Message)) {
            return false;
        }
        Message mess = (Message)obj;
        NamedValue[] myHeaders = this.getHeaders();
        if (myHeaders.length != (thoseHeaders = mess.getHeaders()).length) {
            return false;
        }
        int i = 0;
        while (i < myHeaders.length) {
            if (!myHeaders[i].getName().equalsIgnoreCase(thoseHeaders[i].getName())) {
                return false;
            }
            if (!myHeaders[i].getValue().equals(thoseHeaders[i].getValue())) {
                return false;
            }
            ++i;
        }
        byte[] myContent = this.getContent();
        byte[] thatContent = mess.getContent();
        return Arrays.equals(myContent, thatContent);
    }
}

