/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.webscarab.model;

import java.net.MalformedURLException;
import java.util.ArrayList;

public class HttpUrl
implements Comparable {
    private static final HttpUrl[] nullPath = new HttpUrl[0];
    private String _scheme;
    private String _host;
    private int _port;
    private String _path;
    private String _fragment = null;
    private String _query = null;
    private int _hashcode;

    public HttpUrl(String url) throws MalformedURLException {
        if (url.indexOf(10) > -1 || url.indexOf(32) > -1) {
            throw new MalformedURLException("Illegal characters in url: " + url);
        }
        this.parseUrl(url);
        this._hashcode = this.toString().hashCode();
    }

    public HttpUrl(HttpUrl url, String relative) throws MalformedURLException {
        if (relative.indexOf(10) > -1 || relative.indexOf(32) > -1) {
            throw new MalformedURLException("Illegal characters in relative : " + relative);
        }
        if (url == null || relative.startsWith("http://") || relative.startsWith("https://")) {
            this.parseUrl(relative);
            this._hashcode = this.toString().hashCode();
            return;
        }
        this._scheme = url.getScheme();
        this._host = url.getHost();
        this._port = url.getPort();
        this._path = relative.startsWith("/") ? relative : this.relativePath(url.getPath(), relative);
        this.splitFragQuery();
        this._path = this._path.replaceAll(" ", "%20");
        if (this._query != null) {
            this._query = this._query.replace(' ', '+');
        }
        if (this._fragment != null) {
            this._fragment = this._fragment.replaceAll(" ", "%20");
        }
        this._hashcode = this.toString().hashCode();
    }

    private void parseUrl(String url) throws MalformedURLException {
        String hp;
        int colon;
        int pos = url.indexOf("://");
        if (pos == -1) {
            throw new MalformedURLException("An URL must have a scheme!");
        }
        this._scheme = url.substring(0, pos).toLowerCase();
        if (!this._scheme.equals("http") && !this._scheme.equals("https")) {
            throw new MalformedURLException("This class only supports HTTP or HTTPS schemes: '" + this._scheme + "'");
        }
        int prev = pos + 3;
        if ((pos = url.indexOf("/", prev)) == -1) {
            pos = url.length();
        }
        if ((colon = (hp = url.substring(prev, pos)).indexOf(":")) == -1) {
            this._host = hp;
            if (this._scheme.equals("http")) {
                this._port = 80;
            } else if (this._scheme.equals("https")) {
                this._port = 443;
            }
        } else {
            try {
                this._host = hp.substring(0, colon);
                this._port = Integer.parseInt(hp.substring(colon + 1));
            }
            catch (NumberFormatException nfe) {
                throw new MalformedURLException("Error parsing the port number: " + nfe);
            }
        }
        if ("".equals(this._host)) {
            throw new MalformedURLException("Host cannot be empty");
        }
        if (this._port < 1 || this._port > 65535) {
            throw new MalformedURLException("Port out of range: " + this._port);
        }
        if (pos == url.length()) {
            this._path = "/";
        } else {
            this._path = url.substring(pos);
            this.splitFragQuery();
        }
    }

    private String relativePath(String oldPath, String relative) {
        if (!oldPath.endsWith("/")) {
            oldPath = this.parentPath(oldPath);
        }
        while (relative.startsWith("../") || relative.startsWith("./")) {
            if (relative.startsWith("./")) {
                relative = relative.substring(2);
                continue;
            }
            relative = relative.substring(3);
            if (oldPath.length() <= 1) continue;
            oldPath = this.parentPath(oldPath);
        }
        return String.valueOf(oldPath) + relative;
    }

    private void splitFragQuery() {
        int semi;
        int ques;
        int hash = this._path.indexOf("#");
        if (hash > -1) {
            this._path = this._path.substring(0, hash);
        }
        if ((ques = this._path.indexOf("?")) > -1) {
            this._query = this._path.substring(ques + 1);
            this._path = this._path.substring(0, ques);
        }
        if ((semi = this._path.indexOf(";")) > -1) {
            this._fragment = this._path.substring(semi + 1);
            this._path = this._path.substring(0, semi);
        }
    }

    public String getScheme() {
        return this._scheme;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public String getPath() {
        return this._path;
    }

    public String getFragment() {
        return this._fragment;
    }

    public String getQuery() {
        return this._query;
    }

    public String getSHPP() {
        StringBuffer buff = new StringBuffer();
        buff.append(this._scheme).append("://");
        buff.append(this._host).append(":").append(this._port);
        buff.append(this._path);
        return buff.toString();
    }

    public String getParameters() {
        if (this._fragment == null && this._query == null) {
            return null;
        }
        StringBuffer buff = new StringBuffer();
        if (this._fragment != null) {
            buff.append(";").append(this._fragment);
        }
        if (this._query != null) {
            buff.append("?").append(this._query);
        }
        return buff.toString();
    }

    private String parentPath(String path) {
        int secondlast = path.lastIndexOf("/", path.length() - 2);
        return path.substring(0, secondlast + 1);
    }

    public HttpUrl getParentUrl() {
        if (this._scheme.equals("")) {
            throw new NullPointerException("Should not be trying to get the parent of NULL URL");
        }
        try {
            if (this._fragment != null || this._query != null) {
                return new HttpUrl(this.getSHPP());
            }
            if (this._path != null && this._path.length() > 1) {
                String url = this.getSHPP();
                int secondLast = url.lastIndexOf("/", url.length() - 2);
                return new HttpUrl(url.substring(0, secondLast + 1));
            }
            return null;
        }
        catch (MalformedURLException mue) {
            System.err.println("Malformed URL calculating parent path of " + this.toString());
            return null;
        }
    }

    public HttpUrl[] getUrlHierarchy() {
        ArrayList<HttpUrl> list = new ArrayList<HttpUrl>();
        list.add(this);
        HttpUrl url = this.getParentUrl();
        while (url != null) {
            list.add(0, url);
            url = url.getParentUrl();
        }
        return list.toArray(nullPath);
    }

    public String toString() {
        if (this._scheme.equals("")) {
            return "NULL URL";
        }
        StringBuffer buff = new StringBuffer();
        buff.append(this._scheme).append("://");
        buff.append(this._host).append(":").append(this._port);
        return this.direct(buff).toString();
    }

    public StringBuffer direct(StringBuffer buff) {
        buff.append(this._path);
        if (this._fragment != null) {
            buff.append(";").append(this._fragment);
        }
        if (this._query != null) {
            buff.append("?").append(this._query);
        }
        return buff;
    }

    public String direct() {
        return this.direct(new StringBuffer()).toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof HttpUrl)) {
            return false;
        }
        if (this._hashcode != o.hashCode()) {
            return false;
        }
        return this.compareTo(o) == 0;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        if (!(o instanceof HttpUrl)) {
            throw new ClassCastException("Can only compare HttpUrls, not a " + o.getClass().getName());
        }
        HttpUrl url = (HttpUrl)o;
        int result = this._scheme.compareTo(url.getScheme());
        if (result != 0) {
            return result;
        }
        result = this._host.compareTo(url.getHost());
        if (result != 0) {
            return result;
        }
        result = this._port - url.getPort();
        if (result != 0) {
            return result;
        }
        result = this._path.compareTo(url.getPath());
        if (result != 0) {
            return result;
        }
        result = this._fragment == null ? (url.getFragment() == null ? 0 : -1) : (url.getFragment() == null ? 1 : this._fragment.compareTo(url.getFragment()));
        if (result != 0) {
            return result;
        }
        result = this._query == null ? (url.getQuery() == null ? 0 : -1) : (url.getQuery() == null ? 1 : this._query.compareTo(url.getQuery()));
        return result;
    }

    public int hashCode() {
        return this._hashcode;
    }
}

