/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrftester;

import java.util.regex.Pattern;
import org.owasp.csrftester.CSRFTesterModel;

public class LinkTransformer {
    public static final Pattern FORM_PATTERN = Pattern.compile("(?i)</form>");
    public static final Pattern SKIPPABLE_PATTERN = Pattern.compile(CSRFTesterModel.DEFAULT_EXCLUDE_PATTERN);
    public static final String CSRFTESTER = "CSRFTESTER";
    private String errorPage = null;

    public static String transform(String original) {
        String content = LinkTransformer.buildFormParameters(original);
        content = LinkTransformer.buildLinkParameters(content);
        return content;
    }

    private static String buildFormParameters(String content) {
        return FORM_PATTERN.matcher(content).replaceAll("<input type=\"hidden\" name=\"CSRFTESTER\">\n</form>");
    }

    private static String buildLinkParameters(String content) {
        content = LinkTransformer.buildLinkParameters(content, "<a", "href=");
        return content;
    }

    private static String buildLinkParameters(String content, String tag, String attr) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = content.length();
        int tagEnd = 0;
        while (i < length) {
            String update;
            int tagStart = content.toLowerCase().indexOf(tag, i);
            if (tagStart != -1) {
                buffer.append(content.substring(tagEnd + 1, tagStart));
                tagEnd = content.toLowerCase().indexOf(62, tagStart + 1);
                if (tagEnd != -1) {
                    String tagContent = content.substring(tagStart, tagEnd + 1);
                    System.out.println("*" + tagContent);
                    int attrStart = tagContent.toLowerCase().indexOf(attr);
                    if (attrStart != -1) {
                        int attrEnd = tagContent.toLowerCase().indexOf(34, attrStart + attr.length() + 1);
                        if (attrEnd == -1) {
                            attrEnd = tagContent.toLowerCase().indexOf(32, tagStart + 1);
                        }
                        if (attrEnd == -1) {
                            attrEnd = tagContent.length() - 1;
                        }
                        if (attrEnd != -1) {
                            String attrContent = tagContent.substring(attrStart + attr.length(), attrEnd);
                            System.out.println("    AC:" + attrContent);
                            String newAttrContent = String.valueOf(attrContent) + (attrContent.contains("?") ? "&" : "?") + CSRFTESTER;
                            tagContent = String.valueOf(tagContent.substring(0, attrStart + attr.length())) + newAttrContent + tagContent.substring(attrEnd);
                            System.out.println("        -> " + tagContent);
                        }
                    }
                    buffer.append(tagContent);
                    i = tagEnd + 1;
                    continue;
                }
                update = content.substring(i);
                buffer.append(update);
                i += update.length();
                continue;
            }
            update = content.substring(i);
            buffer.append(update);
            i += update.length();
        }
        return buffer.toString();
    }

    public static void main(String[] args) {
        String test1 = "blahc  alsdkfj<a name=\"test\">lkwej  f <a href=test?one></a> asdlfkj<form action=\"abc://test\" blue=blue>test</form><form test=\"a\" action=\"bang\"> test<a class=q href=\"http://froogle.google.com/frghp?ie=UTF-8&oe=UTF-8&hl=en&tab=wf\" onclick=\"return qs(this)\"> test 123";
        System.out.println("*********A href\n" + test1);
        System.out.println("*********A href\n" + LinkTransformer.buildLinkParameters(test1, "<a", "href="));
    }
}

