/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.csrftester;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.owasp.csrftester.BrowserLaunch;
import org.owasp.csrftester.CSRFTesterListTableModel;
import org.owasp.csrftester.CSRFTesterModel;
import org.owasp.csrftester.report.Report;
import org.owasp.csrftester.report.ReportFactory;

public class CSRFTesterUI
extends JFrame
implements ListSelectionListener,
TableModelListener {
    private boolean recording = false;
    CSRFTesterModel model = null;
    CSRFTesterListTableModel requestQueryModel = null;
    CSRFTesterListTableModel requestFormModel = null;
    private JButton clearAllButton;
    private JLabel excludeLabel;
    private JTextField excludeRegexField;
    private JButton excludeResetButton;
    private JFileChooser htmlSaveDialog;
    private JLabel includeLabel;
    private JTextField includeRegexField;
    private JButton includeResetButton;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPopupMenu jPopupMenu1;
    private JPopupMenu jPopupMenu2;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButton4;
    private JRadioButton jRadioButton5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSplitPane jSplitPane1;
    private JTable jtable;
    private JMenuItem menuExit;
    private JMenu menuFile;
    private JMenuItem menuLoad;
    private JMenu menuOptions;
    private JMenuItem menuSave;
    private JFileChooser rawFileLoadDialog;
    private JFileChooser rawFileSaveDialog;
    private JPanel requestEditor;
    private JTable requestFormParams;
    private JComboBox requestMethod;
    private JTextField requestPause;
    private JTable requestQueryParams;
    private JTextField requestStep;
    private JTextField requestURL;
    private JToggleButton startButton;
    private JLabel statusBar;
    private JScrollPane tableScrollPane;
    private JButton testButton;
    private JLabel titleLabel;

    public CSRFTesterUI(CSRFTesterModel model) {
        this.initComponents();
        this.model = model;
        this.jtable.setModel(model);
        ListSelectionModel selectionModel = this.jtable.getSelectionModel();
        selectionModel.addListSelectionListener(this);
        this.includeRegexField.setText(CSRFTesterModel.DEFAULT_INCLUDE_PATTERN);
        this.excludeRegexField.setText(CSRFTesterModel.DEFAULT_EXCLUDE_PATTERN);
        this.requestQueryModel = new CSRFTesterListTableModel("Query Parameters");
        this.requestFormModel = new CSRFTesterListTableModel("Form Parameters");
        this.requestQueryModel.addTableModelListener(this);
        this.requestFormModel.addTableModelListener(this);
        this.requestQueryParams.setModel(this.requestQueryModel);
        this.requestFormParams.setModel(this.requestFormModel);
    }

    private void initComponents() {
        this.jPopupMenu1 = new JPopupMenu();
        this.jMenuItem4 = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.jPopupMenu2 = new JPopupMenu();
        this.jMenuItem6 = new JMenuItem();
        this.htmlSaveDialog = new JFileChooser();
        this.rawFileSaveDialog = new JFileChooser();
        this.rawFileLoadDialog = new JFileChooser();
        this.jPanel1 = new JPanel();
        this.startButton = new JToggleButton();
        this.titleLabel = new JLabel();
        this.clearAllButton = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.tableScrollPane = new JScrollPane();
        this.jtable = new JTable();
        this.requestEditor = new JPanel();
        this.requestStep = new JTextField();
        this.requestPause = new JTextField();
        this.requestMethod = new JComboBox();
        this.requestURL = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.requestQueryParams = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.requestFormParams = new JTable();
        this.jPanel2 = new JPanel();
        this.includeLabel = new JLabel();
        this.excludeLabel = new JLabel();
        this.includeRegexField = new JTextField();
        this.excludeRegexField = new JTextField();
        this.excludeResetButton = new JButton();
        this.includeResetButton = new JButton();
        this.testButton = new JButton();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.jRadioButton4 = new JRadioButton();
        this.jRadioButton5 = new JRadioButton();
        this.jSeparator1 = new JSeparator();
        this.statusBar = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.menuFile = new JMenu();
        this.menuSave = new JMenuItem();
        this.menuLoad = new JMenuItem();
        this.menuExit = new JMenuItem();
        this.menuOptions = new JMenu();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem4.setText("Delete selected rows");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.jMenuItem4ActionPerformed(evt);
            }
        });
        this.jPopupMenu1.add(this.jMenuItem4);
        this.jMenuItem5.setText("TBD");
        this.jPopupMenu1.add(this.jMenuItem5);
        this.jMenuItem6.setText("Eric");
        this.jPopupMenu2.add(this.jMenuItem6);
        this.htmlSaveDialog.setAcceptAllFileFilterUsed(false);
        this.htmlSaveDialog.setDialogTitle("Choose directory to store saved CSRF attack");
        this.htmlSaveDialog.setDialogType(1);
        this.htmlSaveDialog.setFileHidingEnabled(true);
        this.htmlSaveDialog.setFileSelectionMode(1);
        this.rawFileSaveDialog.setAcceptAllFileFilterUsed(false);
        this.rawFileSaveDialog.setDialogTitle("Save project file");
        this.rawFileSaveDialog.setDialogType(1);
        this.rawFileSaveDialog.setFileHidingEnabled(true);
        this.rawFileLoadDialog.setAcceptAllFileFilterUsed(false);
        this.rawFileLoadDialog.setDialogTitle("Load saved project file");
        this.rawFileLoadDialog.setFileHidingEnabled(true);
        this.setDefaultCloseOperation(3);
        this.setTitle("OWASP CSRFTester");
        this.setBackground(new Color(255, 255, 255));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                CSRFTesterUI.this.exitHandler(evt);
            }
        });
        this.startButton.setText("Start Recording");
        this.startButton.setMaximumSize(new Dimension(150, 25));
        this.startButton.setMinimumSize(new Dimension(150, 25));
        this.startButton.setPreferredSize(new Dimension(150, 25));
        this.startButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.startButtonActionPerformed(evt);
            }
        });
        this.titleLabel.setFont(new Font("Papyrus", 1, 18));
        this.titleLabel.setText("OWASP CSRFTester");
        this.clearAllButton.setText("Clear All");
        this.clearAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.clearAllButtonActionPerformed(evt);
            }
        });
        this.jSplitPane1.setBackground(new Color(255, 255, 255));
        this.jSplitPane1.setDividerLocation(200);
        this.jSplitPane1.setOrientation(0);
        this.tableScrollPane.setBackground(SystemColor.info);
        this.tableScrollPane.setBorder(BorderFactory.createEtchedBorder());
        this.tableScrollPane.setComponentPopupMenu(this.jPopupMenu1);
        this.tableScrollPane.setAutoscrolls(true);
        this.jtable.setComponentPopupMenu(this.jPopupMenu1);
        this.jtable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Title 1", "Title 2", "Title 3", "Title 4", "Title 5"}));
        this.jtable.setAutoResizeMode(1);
        this.jtable.setShowVerticalLines(false);
        this.tableScrollPane.setViewportView(this.jtable);
        this.jSplitPane1.setTopComponent(this.tableScrollPane);
        this.requestStep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.requestStepActionPerformed(evt);
            }
        });
        this.requestPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.requestPauseActionPerformed(evt);
            }
        });
        this.requestMethod.setModel(new DefaultComboBoxModel<String>(new String[]{"GET", "POST", "TRACE"}));
        this.requestMethod.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.requestMethodActionPerformed(evt);
            }
        });
        this.requestURL.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.requestURLActionPerformed(evt);
            }
        });
        this.requestQueryParams.setModel(new DefaultTableModel(new Object[][]{new Object[4], new Object[4], new Object[4], new Object[4]}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane1.setViewportView(this.requestQueryParams);
        this.requestFormParams.setModel(new DefaultTableModel(new Object[][]{new Object[4], new Object[4], new Object[4], new Object[4]}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView(this.requestFormParams);
        GroupLayout requestEditorLayout = new GroupLayout(this.requestEditor);
        this.requestEditor.setLayout(requestEditorLayout);
        requestEditorLayout.setHorizontalGroup(requestEditorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, requestEditorLayout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 306, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 306, Short.MAX_VALUE)).addGroup(requestEditorLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.requestMethod, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.requestURL, -1, 536, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, requestEditorLayout.createSequentialGroup().addComponent(this.requestStep, -1, 553, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.requestPause, -2, 59, -2)));
        requestEditorLayout.setVerticalGroup(requestEditorLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(requestEditorLayout.createSequentialGroup().addGroup(requestEditorLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.requestStep, -2, -1, -2).addComponent(this.requestPause, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(requestEditorLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.requestURL, -2, -1, -2).addComponent(this.requestMethod, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(requestEditorLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane1, -1, 92, Short.MAX_VALUE).addComponent(this.jScrollPane2, -1, 92, Short.MAX_VALUE)).addContainerGap()));
        this.jSplitPane1.setBottomComponent(this.requestEditor);
        this.includeLabel.setText("Include Regex: ");
        this.excludeLabel.setText("Exclude Regex:");
        this.includeRegexField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.includeRegexFieldActionPerformed(evt);
            }
        });
        this.includeRegexField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                CSRFTesterUI.this.includeRegexFieldKeyTyped(evt);
            }
        });
        this.excludeRegexField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.excludeRegexFieldActionPerformed(evt);
            }
        });
        this.excludeRegexField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent evt) {
                CSRFTesterUI.this.excludeRegexFieldKeyTyped(evt);
            }
        });
        this.excludeResetButton.setText("Reset");
        this.excludeResetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.excludeResetButtonActionPerformed(evt);
            }
        });
        this.includeResetButton.setText("Reset");
        this.includeResetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.includeResetButtonActionPerformed(evt);
            }
        });
        this.testButton.setText("Generate HTML");
        this.testButton.setMaximumSize(new Dimension(150, 25));
        this.testButton.setMinimumSize(new Dimension(150, 25));
        this.testButton.setPreferredSize(new Dimension(150, 25));
        this.testButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.testButtonActionPerformed(evt);
            }
        });
        this.jCheckBox1.setText("Display in Browser");
        this.jCheckBox1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBox1.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBox1.setSelected(true);
        this.jLabel1.setText("Report Type:");
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("Forms");
        this.jRadioButton1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButton1.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.jRadioButton2.setText("iFrame");
        this.jRadioButton2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButton2.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.jRadioButton3.setText("IMG");
        this.jRadioButton3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButton3.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.jRadioButton3ActionPerformed(evt);
            }
        });
        this.jRadioButton4.setText("XHR");
        this.jRadioButton4.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButton4.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.jRadioButton4ActionPerformed(evt);
            }
        });
        this.jRadioButton5.setText("Link");
        this.jRadioButton5.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButton5.setMargin(new Insets(0, 0, 0, 0));
        this.jRadioButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.jRadioButton5ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.excludeLabel).addComponent(this.includeLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.includeRegexField, -1, 473, Short.MAX_VALUE).addComponent(this.excludeRegexField, -1, 473, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.excludeResetButton, -1, -1, Short.MAX_VALUE).addComponent(this.includeResetButton, -1, -1, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(14, 14, 14).addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 93, Short.MAX_VALUE).addComponent(this.jCheckBox1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testButton, -2, -1, -2)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.includeLabel).addComponent(this.includeResetButton).addComponent(this.includeRegexField, -2, 21, -2)).addGap(0, 0, 0).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.excludeLabel).addComponent(this.excludeResetButton).addComponent(this.excludeRegexField, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 14, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.testButton, -2, -1, -2).addComponent(this.jCheckBox1).addComponent(this.jRadioButton5).addComponent(this.jRadioButton4).addComponent(this.jRadioButton3).addComponent(this.jRadioButton2).addComponent(this.jRadioButton1).addComponent(this.jLabel1))));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.titleLabel, -1, 310, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearAllButton, -2, 120, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startButton, -2, -1, -2).addGap(10, 10, 10)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jSplitPane1, -1, 620, Short.MAX_VALUE)).addContainerGap()))));
        jPanel1Layout.linkSize(0, this.clearAllButton, this.startButton);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.titleLabel).addComponent(this.startButton, -2, -1, -2).addComponent(this.clearAllButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSplitPane1, -1, 361, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2)));
        this.statusBar.setFont(new Font("Tahoma", 0, 10));
        this.statusBar.setForeground(new Color(153, 153, 153));
        this.statusBar.setBorder(BorderFactory.createEmptyBorder(1, 4, 4, 1));
        this.statusBar.setVerticalTextPosition(1);
        this.menuFile.setText("File");
        this.menuFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.menuFileActionPerformed(evt);
            }
        });
        this.menuSave.setText("Save");
        this.menuSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.menuSaveActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuSave);
        this.menuLoad.setText("Load");
        this.menuLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.menuLoadActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuLoad);
        this.menuExit.setText("Exit");
        this.menuExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.menuExitActionPerformed(evt);
            }
        });
        this.menuFile.add(this.menuExit);
        this.jMenuBar1.add(this.menuFile);
        this.menuOptions.setText("Options");
        this.jMenuItem3.setText("TBD");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CSRFTesterUI.this.jMenuItem3ActionPerformed(evt);
            }
        });
        this.menuOptions.add(this.jMenuItem3);
        this.jMenuBar1.add(this.menuOptions);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING, -1, 640, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.statusBar, -1, 640, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addGap(0, 0, 0).addComponent(this.statusBar, -2, 17, -2)));
        this.pack();
    }

    private void jRadioButton5ActionPerformed(ActionEvent evt) {
        this.jRadioButton1.setSelected(false);
        this.jRadioButton2.setSelected(false);
        this.jRadioButton3.setSelected(false);
        this.jRadioButton4.setSelected(false);
        this.jRadioButton5.setSelected(true);
    }

    private void jRadioButton4ActionPerformed(ActionEvent evt) {
        this.jRadioButton1.setSelected(false);
        this.jRadioButton2.setSelected(false);
        this.jRadioButton3.setSelected(false);
        this.jRadioButton4.setSelected(true);
        this.jRadioButton5.setSelected(false);
    }

    private void jRadioButton3ActionPerformed(ActionEvent evt) {
        this.jRadioButton1.setSelected(false);
        this.jRadioButton2.setSelected(false);
        this.jRadioButton3.setSelected(true);
        this.jRadioButton4.setSelected(false);
        this.jRadioButton5.setSelected(false);
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.jRadioButton1.setSelected(false);
        this.jRadioButton2.setSelected(true);
        this.jRadioButton3.setSelected(false);
        this.jRadioButton4.setSelected(false);
        this.jRadioButton5.setSelected(false);
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.jRadioButton1.setSelected(true);
        this.jRadioButton2.setSelected(false);
        this.jRadioButton3.setSelected(false);
        this.jRadioButton4.setSelected(false);
        this.jRadioButton5.setSelected(false);
    }

    private void exitHandler(WindowEvent evt) {
        if (this.model.saveNeeded()) {
            System.out.println("SAVE NEEDED");
        }
        System.exit(0);
    }

    private void menuLoadActionPerformed(ActionEvent evt) {
        this.rawFileLoadDialog.showOpenDialog(this);
        File f = this.rawFileLoadDialog.getSelectedFile();
        try {
            this.statusBar.setText("Loading " + f.getName());
            this.model.load(f);
            this.statusBar.setText("Loaded " + f.getName());
        }
        catch (IOException e) {
            this.statusBar.setText("Error loading " + f.getName() + " - " + e.getMessage());
        }
    }

    private void requestPauseActionPerformed(ActionEvent evt) {
        String value = this.requestPause.getText();
        int row = this.jtable.getSelectedRow();
        this.model.setPause(row, value);
    }

    private void requestMethodActionPerformed(ActionEvent evt) {
        String value = this.requestMethod.getSelectedItem().toString();
        int row = this.jtable.getSelectedRow();
        this.model.setMethod(row, value);
    }

    private void requestURLActionPerformed(ActionEvent evt) {
        String value = this.requestURL.getText();
        String params = ((CSRFTesterListTableModel)this.requestQueryParams.getModel()).getParams();
        if (params != null && params.length() > 0) {
            value = String.valueOf(value) + "?" + params;
        }
        int row = this.jtable.getSelectedRow();
        this.model.setURL(row, value);
    }

    private void requestStepActionPerformed(ActionEvent evt) {
        String value = this.requestStep.getText();
        int row = this.jtable.getSelectedRow();
        this.model.setStepName(row, value);
    }

    private void excludeResetButtonActionPerformed(ActionEvent evt) {
        this.excludeRegexFieldActionPerformed(new ActionEvent(this.includeRegexField, 0, CSRFTesterModel.DEFAULT_EXCLUDE_PATTERN));
    }

    private void includeResetButtonActionPerformed(ActionEvent evt) {
        this.includeRegexFieldActionPerformed(new ActionEvent(this.includeRegexField, 0, CSRFTesterModel.DEFAULT_INCLUDE_PATTERN));
    }

    private void startRecording() {
        this.recording = true;
        this.startButton.setText("Stop Recording");
        this.setStatus(false, "Recording started");
    }

    private void stopRecording() {
        this.recording = false;
        this.startButton.setText("Start Recording");
        this.startButton.setSelected(false);
        this.setStatus(false, "Recording stopped");
    }

    public void setStatus(boolean error, String message) {
        if (error) {
            this.statusBar.setText("Error: " + message);
            Toolkit.getDefaultToolkit().beep();
        } else {
            this.statusBar.setText(message);
        }
    }

    private void clearAllButtonActionPerformed(ActionEvent evt) {
        this.stopRecording();
        this.model.clear();
        this.setStatus(false, "All requests cleared");
    }

    private void excludeRegexFieldActionPerformed(ActionEvent evt) {
        String pattern = evt.getActionCommand();
        try {
            this.model.setExcludePattern(pattern);
            this.setStatus(false, "");
        }
        catch (PatternSyntaxException e) {
            this.setStatus(true, e.getMessage());
            return;
        }
        this.excludeRegexField.setText(pattern);
        this.excludeRegexField.setBackground(Color.WHITE);
    }

    private void includeRegexFieldActionPerformed(ActionEvent evt) {
        String pattern = evt.getActionCommand();
        try {
            this.model.setIncludePattern(pattern);
            this.setStatus(false, "");
        }
        catch (PatternSyntaxException e) {
            this.setStatus(true, e.getMessage());
            return;
        }
        this.includeRegexField.setText(pattern);
        this.includeRegexField.setBackground(Color.WHITE);
    }

    private void excludeRegexFieldKeyTyped(KeyEvent evt) {
        char c = evt.getKeyChar();
        if (c != '\n') {
            this.excludeRegexField.setBackground(Color.YELLOW);
        }
    }

    private void includeRegexFieldKeyTyped(KeyEvent evt) {
        char c = evt.getKeyChar();
        if (c != '\n') {
            this.includeRegexField.setBackground(Color.YELLOW);
        }
    }

    private void deleteSelectedRows() {
        this.recording = false;
        this.startButton.setText("Start Recording");
        while (this.jtable.getSelectedRowCount() > 0) {
            int row = this.jtable.getSelectedRow();
            this.model.removeRow(row);
        }
        this.setStatus(false, "Selected requests deleted");
    }

    private void jMenuItem4ActionPerformed(ActionEvent evt) {
        this.deleteSelectedRows();
    }

    private void jMenuItem3ActionPerformed(ActionEvent evt) {
        System.out.println("TBD");
    }

    private void menuExitActionPerformed(ActionEvent evt) {
        if (this.model.saveNeeded()) {
            System.out.println("SAVE NEEDED");
        }
        System.exit(0);
    }

    private void menuSaveActionPerformed(ActionEvent evt) {
        this.rawFileSaveDialog.showSaveDialog(this);
        File f = this.rawFileSaveDialog.getSelectedFile();
        try {
            this.statusBar.setText("Saving " + f.getName());
            this.model.save(f);
            this.statusBar.setText("Saved " + f.getName());
        }
        catch (IOException e) {
            this.statusBar.setText("Error saving " + f.getName() + " - " + e.getMessage());
        }
    }

    private void menuFileActionPerformed(ActionEvent evt) {
    }

    private void startButtonActionPerformed(ActionEvent evt) {
        if (this.recording) {
            this.stopRecording();
        } else {
            this.startRecording();
        }
    }

    private void testButtonActionPerformed(ActionEvent evt) {
        try {
            if (this.isLinkReport()) {
                String linkText = JOptionPane.showInputDialog(this, (Object)"What text would you like this link to display?");
                this.model.setLinkText(linkText);
            }
            this.htmlSaveDialog.showSaveDialog(this);
            File dir = this.htmlSaveDialog.getSelectedFile();
            if (dir != null) {
                this.statusBar.setText("Saving HTML test file " + dir.getName());
                int reportType = this.getReportType();
                ReportFactory factory = ReportFactory.getInstance();
                Report report = factory.getReport(reportType);
                String url = report.generateHtml(this.model, dir);
                if (this.showInBrowser()) {
                    this.statusBar.setText("Launching newly created HTML file in browser");
                    BrowserLaunch.openURL(url);
                }
                this.statusBar.setText("HTML test file saved to " + dir.getName());
            } else {
                this.statusBar.setText("User operation cancelled");
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private boolean showInBrowser() {
        return this.jCheckBox1.isSelected();
    }

    private int getReportType() {
        int reportType = 0;
        if (this.jRadioButton1.isSelected()) {
            reportType = 0;
        } else if (this.jRadioButton2.isSelected()) {
            reportType = 2;
        } else if (this.jRadioButton3.isSelected()) {
            reportType = 3;
        } else if (this.jRadioButton4.isSelected()) {
            reportType = 1;
        } else if (this.jRadioButton5.isSelected()) {
            reportType = 4;
        }
        return reportType;
    }

    public boolean isRecording() {
        return this.recording;
    }

    @Override
    public void valueChanged(ListSelectionEvent event) {
        if (event.getSource() == this.jtable.getSelectionModel() && event.getFirstIndex() >= 0) {
            int row = this.jtable.getSelectedRow();
            if (row < 0 || row > this.jtable.getRowCount()) {
                return;
            }
            this.statusBar.setText("Moving to row " + row);
            this.requestStep.setText(this.model.getStepName(row));
            this.requestPause.setText("" + this.model.getPause(row));
            this.requestMethod.setSelectedItem(this.model.getMethod(row));
            String url = this.model.getURL(row);
            String query = "";
            int index = url.indexOf(63);
            if (index != -1) {
                query = url.substring(index + 1);
                url = url.substring(0, index);
            }
            this.requestURL.setText(url);
            String[] qsplit = query.split("&");
            this.updateListModel((CSRFTesterListTableModel)this.requestQueryParams.getModel(), qsplit);
            String[] fsplit = this.model.getParameters(row).split("&");
            this.updateListModel((CSRFTesterListTableModel)this.requestFormParams.getModel(), fsplit);
        }
    }

    private void updateListModel(CSRFTesterListTableModel lm, String[] values) {
        while (lm.getRowCount() > 0) {
            lm.removeRow(0);
        }
        int i = 0;
        while (i < values.length) {
            Object[] row = new String[]{values[i]};
            lm.addRow(row);
            ++i;
        }
        Object[] blank = new String[]{""};
        lm.addRow(blank);
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        int row = this.jtable.getSelectedRow();
        if (e.getSource() == this.requestFormModel) {
            this.model.setParameters(row, ((CSRFTesterListTableModel)this.requestFormParams.getModel()).getParams());
        } else if (e.getSource() == this.requestQueryModel) {
            String url = this.requestURL.getText();
            String params = ((CSRFTesterListTableModel)this.requestQueryParams.getModel()).getParams();
            if (params != null && params.length() > 0) {
                url = String.valueOf(url) + "?" + params;
            }
            this.model.setURL(row, url);
        }
    }

    private boolean isLinkReport() {
        return this.jRadioButton5.isSelected();
    }
}

