# Contributing

All contributions to AutoSploit are not only welcomed, but highly appreciated, please keep in mind the following while making a pull request:

- Each request should make at least one logical change
- All contributions should be forked from the `dev-beta` branch
- Each request will need to be reviewed before merged, if anything seems weird we will either fix it or ask you to fix it for us
- If you have multiple pushes in one request, please squash them together (or we will before we merge)
- All pull requests that are merged are provided under the same license as the program is, keep the following in mind;

> By submitting code contributions to AutoSploit via Git pull request or other, checking them into the AutoSploit's source code repository, it is understood (unless you specify otherwise) that you are offering the AutoSploit copyright holders the unlimited, non-exclusive right to reuse, modify, and re-license the code. This is important because the inability to re-license code has caused devastating problems for other software projects (such as KDE and NASM). If you wish to specify special license conditions of your contributions, just say so when you send them.

## Getting started

To get started making a contribution please do the following:

- Read our [contribution standards](https://github.com/NullArray/AutoSploit/wiki/Development-information#contribution-standards)
- Fork the repository using the fork button
- `git clone https://github.com/<YOUR-NAME>/AutoSploit.git -b dev-beta`
- Edit the code to your liking
- After editing `git branch <YOUR-BRANCH-NAME> && git checkout <YOUR-BRANCH-NAME>`
- Add your commits and comment them
- `git push --set-upstream origin <YOUR-BRANCH>`
- Open a [pull request](https://github.com/NullArray/AutoSploit/pulls)
- Wait for us to check it out

  Thank you.
