/*
 * Decompiled with CFR 0.152.
 */
package javapayload.stage;

import java.io.InputStream;
import java.io.PrintStream;
import javapayload.stage.JShSignalSender;

public class JShStreamForwarder
extends Thread {
    private final InputStream in;
    private PrintStream out;
    private boolean paused = false;
    private boolean finished = false;
    private final JShSignalSender signalSender;

    public JShStreamForwarder(InputStream in, PrintStream out, JShSignalSender signalSender) {
        this.in = in;
        this.out = out;
        this.signalSender = signalSender;
        this.start();
    }

    public synchronized boolean isFinished() {
        return this.finished;
    }

    public synchronized void pauseForwarding(boolean paused) {
        this.paused = paused;
        this.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            try {
                JShStreamForwarder jShStreamForwarder;
                int length;
                byte[] buf = new byte[4096];
                while ((length = this.in.read(buf)) != -1) {
                    jShStreamForwarder = this;
                    synchronized (jShStreamForwarder) {
                        while (this.paused) {
                            this.wait();
                        }
                        if (this.out != null) {
                            this.out.write(buf, 0, length);
                            if (this.in.available() == 0) {
                                this.out.flush();
                            }
                        }
                    }
                }
                jShStreamForwarder = this;
                synchronized (jShStreamForwarder) {
                    this.finished = true;
                    if (!this.paused) {
                        this.signalSender.signal();
                    }
                }
            }
            finally {
                this.in.close();
            }
        }
        catch (Throwable ex) {
            JShStreamForwarder jShStreamForwarder = this;
            synchronized (jShStreamForwarder) {
                while (this.paused) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.out != null) {
                    ex.printStackTrace(this.out);
                    this.out.flush();
                }
            }
        }
    }

    public synchronized void stopForwarding() {
        this.out = null;
    }
}

